/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.local;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import com.vmware.vipclient.i18n.messages.api.opt.MessageOpt;
import com.vmware.vipclient.i18n.messages.api.opt.Opt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONBundleUtil;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMessagesOpt
implements Opt,
MessageOpt {
    private Logger logger = LoggerFactory.getLogger((String)LocalMessagesOpt.class.getName());
    private static final String OFFLINE_RESOURCE_PATH = "{0}{1}/messages_{2}.json";
    private MessagesDTO dto;

    public LocalMessagesOpt(MessagesDTO dto) {
        this.dto = dto;
    }

    @Deprecated
    public JSONObject getComponentMessages() {
        return JSONBundleUtil.getMessages(this.dto.getLocale(), this.dto.getProductID(), this.dto.getVersion(), this.dto.getComponent());
    }

    @Override
    public void getComponentMessages(MessageCacheItem cacheItem) {
        InputStream is = null;
        try {
            is = this.getInputStream();
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse((Reader)new InputStreamReader(is, "UTF-8"));
            JSONObject messages = (JSONObject)jsonObject.get((Object)"messages");
            cacheItem.setCacheItem((Map<String, String>)messages, null, System.currentTimeMillis(), null);
        }
        catch (Exception e) {
            String msg = "Failed to get offline messages for product: " + this.dto.getProductID() + " " + this.dto.getVersion() + ", component: " + this.dto.getComponent() + ", locale: " + this.dto.getLocale() + ", exception: " + e.getMessage();
            if (!"source".equals(this.dto.getLocale())) {
                this.logger.error(msg);
            }
            this.logger.debug(msg);
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                this.logger.debug(e.getMessage());
            }
        }
    }

    private InputStream getInputStream() {
        String locale = LocaleUtility.fmtToMappedLocale(this.dto.getLocale()).toLanguageTag();
        while (true) {
            String offlineResourcePath;
            if (!(offlineResourcePath = VIPCfg.getInstance().getOfflineResourcesBaseUrl()).endsWith("/")) {
                offlineResourcePath = offlineResourcePath + "/";
            }
            String filePath = FormatUtils.format(OFFLINE_RESOURCE_PATH, offlineResourcePath, this.dto.getComponent(), locale);
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            if (is != null) {
                return is;
            }
            int index = locale.lastIndexOf("-");
            if (index <= 0) break;
            locale = locale.substring(0, index);
        }
        throw new VIPJavaClientException("Failed to get resource bundle for locale: " + locale);
    }
}

