/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.BaseOpt;
import com.vmware.vipclient.i18n.messages.api.opt.KeyBasedOpt;
import com.vmware.vipclient.i18n.messages.api.opt.Opt;
import com.vmware.vipclient.i18n.messages.api.url.URLUtils;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringBasedOpt
extends BaseOpt
implements Opt,
KeyBasedOpt {
    private final Logger logger = LoggerFactory.getLogger(StringBasedOpt.class);
    private MessagesDTO dto = null;

    public StringBasedOpt(MessagesDTO dto) {
        this.dto = dto;
    }

    public JSONObject getComponentMessages() {
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getComponentTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", null);
        String responseStr = (String)response.get("body");
        if (null == responseStr || responseStr.equals("")) {
            return null;
        }
        Object dataObj = this.getMessagesFromResponse(responseStr, "messages");
        JSONObject msgObject = null;
        if (dataObj != null && !"".equalsIgnoreCase(dataObj.toString())) {
            msgObject = (JSONObject)dataObj;
        }
        return msgObject;
    }

    public String getString() {
        String k;
        JSONObject jo = this.getComponentMessages();
        Object v = jo.get((Object)(k = this.dto.getKey()));
        return v == null ? "" : (String)v;
    }

    public String postString() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", this.dto.getSource());
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getKeyTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "POST", params);
        String responseStr = (String)response.get("body");
        Object o = this.getMessagesFromResponse(responseStr, "translation");
        if (o != null) {
            return (String)o;
        }
        return "";
    }

    public String postSourceSet(String sourceSet) {
        String status = "";
        if (sourceSet == null || "".equalsIgnoreCase(sourceSet)) {
            return status;
        }
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getPostKeys(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "POST", sourceSet);
        String responseStr = (String)response.get("body");
        Object o = this.getStatusFromResponse(responseStr, "code");
        if (o != null) {
            status = o.toString();
        }
        return status;
    }

    public String getTranslationStatus() {
        String status = "";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkTranslationStatus", "true");
        String getURL = V2URL.getComponentTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL());
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(getURL, "GET", params);
        String responseStr = (String)response.get("body");
        if (null == responseStr || responseStr.equals("")) {
            return status;
        }
        Object o = this.getMessagesFromResponse(responseStr, "status");
        if (o != null) {
            status = o.toString();
        }
        return status;
    }

    @Override
    public void fetchMultiVersionKeyMessages(MessageCacheItem cacheItem) {
        block9: {
            Map<String, Object> response;
            Integer responseCode;
            String url = V2URL.getMultiVersionKeyTranslationURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL());
            HashMap<String, String> headers = new HashMap<String, String>();
            if (cacheItem.getEtag() != null) {
                headers.put("If-None-Match", cacheItem.getEtag());
            }
            if ((responseCode = (Integer)(response = VIPCfg.getInstance().getVipService().getHttpRequester().request(url, "GET", null, headers)).get("response_code")) != null && (responseCode.equals(200) || responseCode.equals(304))) {
                Long maxAgeMillis;
                long timestamp = response.get("response_timestamp") == null ? System.currentTimeMillis() : (Long)response.get("response_timestamp");
                String etag = URLUtils.createEtagString((Map)response.get("headers"));
                Long l = maxAgeMillis = response.get("max-age") == null ? null : (Long)response.get("max-age");
                if (responseCode.equals(200)) {
                    JSONObject respObj = (JSONObject)JSONValue.parse((String)((String)response.get("body")));
                    try {
                        int businessCode = this.getResponseCode(respObj);
                        if (this.isSuccess(businessCode)) {
                            JSONArray dataArray = (JSONArray)this.getDataPart(respObj);
                            HashMap<String, String> messages = new HashMap<String, String>();
                            for (Object obj : dataArray) {
                                JSONObject keyTranslationObj = (JSONObject)obj;
                                messages.put((String)keyTranslationObj.get((Object)"version"), (String)keyTranslationObj.get((Object)"translation"));
                            }
                            if (messages != null) {
                                cacheItem.setCacheItem(messages, etag, timestamp, maxAgeMillis);
                            }
                            break block9;
                        }
                        this.logger.warn(String.format("Server returned error! Status: %d. Message: %s", businessCode, this.getResponseMessage(respObj)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    cacheItem.setCacheItem(etag, timestamp, maxAgeMillis);
                }
            }
        }
    }
}

