/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.persist.CacheSnapshot;
import com.vmware.vipclient.i18n.base.cache.persist.Loader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationCacheManager {
    Logger logger = LoggerFactory.getLogger(TranslationCacheManager.class);
    private static TranslationCacheManager translationCacheManager;
    private int size = 5000;
    private static Map<String, Cache> container;
    private static CacheSnapshot cacheSnapshot;

    private TranslationCacheManager() {
    }

    public static synchronized TranslationCacheManager getInstance() {
        if (translationCacheManager == null) {
            translationCacheManager = new TranslationCacheManager();
        }
        return translationCacheManager;
    }

    public static Cache getCache(String name) {
        Cache c = container.get(name);
        TranslationCacheManager.cleanEntireCache(c);
        return c;
    }

    @Deprecated
    private static void cleanEntireCache(Cache c) {
        if (VIPCfg.getInstance().getCacheExpiredTime() != 0L && c != null && c.isExpired()) {
            TranslationCacheManager.cleanCache(c);
        }
    }

    @Deprecated
    public static void cleanCache(Cache c) {
        c.clear();
        c.setLastClean(System.currentTimeMillis());
    }

    public int registerCache(String className, Cache c) {
        Cache inCacheObj;
        if (c == null) {
            return -1;
        }
        if (container.size() > this.size) {
            Iterator<String> it = container.keySet().iterator();
            String key = it.next();
            container.remove(key);
            this.logger.info("Remove a cache[key is " + key + "] since it's full!");
        }
        if ((inCacheObj = container.get(className)) != null && inCacheObj instanceof Cache) {
            return container.size();
        }
        container.put(className, c);
        return container.size();
    }

    public int registerCache(String className, Class c) {
        Cache inCacheObj;
        if (c == null) {
            return -1;
        }
        if (container.size() > this.size) {
            Iterator<String> it = container.keySet().iterator();
            String key = it.next();
            container.remove(key);
            this.logger.info("Remove a cache[key is " + key + "] since it's full!");
        }
        if ((inCacheObj = container.get(className)) != null && inCacheObj instanceof Cache) {
            return container.size();
        }
        try {
            Object obj = c.newInstance();
            if (obj instanceof Cache) {
                container.put(className, (Cache)obj);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.error(e.getMessage());
        }
        return container.size();
    }

    public int unregisterCache(String cacheName) {
        Cache c = container.get(cacheName);
        if (c != null) {
            container.remove(cacheName);
        }
        return container.size();
    }

    public void clearCache() {
        container.clear();
    }

    public int size() {
        return container.size();
    }

    public synchronized CacheSnapshot getCacheSnapshot() {
        if (cacheSnapshot == null) {
            cacheSnapshot = new CacheSnapshot();
            VIPCfg cfg = VIPCfg.getInstance();
            cacheSnapshot.setCacheRootPath(cfg.getCachePath());
            cacheSnapshot.setProductName(cfg.getProductName());
            cacheSnapshot.setVersion(cfg.getVersion());
            cacheSnapshot.setVipServer(cfg.getVipServer());
            Cache cache = TranslationCacheManager.getCache("CACHE_L3");
            if (null != cache) {
                cacheSnapshot.setLastClean(cache.getLastClean());
                cacheSnapshot.setExpiredTime(cache.getExpiredTime());
                cacheSnapshot.setDropId(cache.getDropId());
                cacheSnapshot.setComponents(cache.keySet());
            }
        }
        return cacheSnapshot;
    }

    public Loader getLoaderInstance(Class c) {
        Loader i = null;
        try {
            Object o = c.newInstance();
            if (o instanceof Loader) {
                i = (Loader)o;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.error(e.getMessage());
        }
        return i;
    }

    static {
        container = new HashMap<String, Cache>();
        cacheSnapshot = null;
    }
}

