/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.formats;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.BaseFormat;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberFormat
extends BaseFormat {
    Logger logger = LoggerFactory.getLogger(NumberFormat.class);

    public String getLocalizedNumber(String number, String scale) {
        if (null == number || number.length() == 0) {
            throw new VIPJavaClientException("number can't be empty");
        }
        if (null == scale || scale.length() == 0) {
            throw new VIPJavaClientException("scale can't be empty");
        }
        if (VIPCfg.getInstance().getVipService().getHttpRequester().isConnected()) {
            return this.getFormatFromRemote(number, scale);
        }
        return "";
    }

    private String getFormatFromRemote(String number, String scale) {
        String format = "";
        StringBuffer numberAPIUrl = new StringBuffer(VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL());
        numberAPIUrl.append("/i18n/api/v1/number/localizedNumber?locale=");
        numberAPIUrl.append(this.locale);
        numberAPIUrl.append("&number=");
        numberAPIUrl.append(number);
        numberAPIUrl.append("&scale=");
        numberAPIUrl.append(scale);
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(numberAPIUrl.toString(), "GET", null);
        String retJsonStr = (String)response.get("body");
        if (null == retJsonStr || retJsonStr.length() == 0) {
            return format;
        }
        try {
            JSONObject dataJson;
            JSONObject retJson = new JSONObject(retJsonStr);
            if (retJson != null && (dataJson = (JSONObject)JSONUtils.getFromJSONObject(retJson, "data")) != null) {
                format = JSONUtils.getFromJSONObject(dataJson, "formattedNumber") == null ? "" : JSONUtils.getFromJSONObject(dataJson, "formattedNumber").toString();
            }
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage());
        }
        return format;
    }
}

