/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.PatternCacheItem;
import com.vmware.vipclient.i18n.messages.service.FormattingCacheService;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternService {
    Logger logger = LoggerFactory.getLogger(PatternService.class);

    public JSONObject getPatternsByCategory(String locale, String category) {
        PatternCacheItem cacheItem = this.getPatternsByLocale(locale);
        JSONObject patterns = new JSONObject(cacheItem.getCachedData());
        return (JSONObject)JSONUtils.getFromJSONObject(patterns, category);
    }

    public JSONObject getPatterns(String locale) {
        PatternCacheItem cacheItem = this.getPatternsByLocale(locale);
        if (!cacheItem.getCachedData().isEmpty()) {
            return new JSONObject(cacheItem.getCachedData());
        }
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        while (fallbackLocalesIter.hasNext()) {
            String fallbackLocale = fallbackLocalesIter.next().toLanguageTag();
            if (fallbackLocale.equalsIgnoreCase(locale)) continue;
            this.logger.info("Can't find pattern for locale [{}], look for fallback locale [{}] pattern as fallback!", (Object)locale, (Object)fallbackLocale);
            cacheItem = this.getPatternsByLocale(fallbackLocale);
            if (cacheItem.getCachedData().isEmpty()) continue;
            return new JSONObject(cacheItem.getCachedData());
        }
        return null;
    }

    public PatternCacheItem getPatternsByLocale(String locale) {
        locale = locale.replace("_", "-");
        PatternCacheItem cacheItem = null;
        this.logger.debug("Look for pattern from cache for locale [{}]!", (Object)locale);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        cacheItem = formattingCacheService.getPatterns(locale);
        if (cacheItem != null) {
            if (cacheItem.isExpired()) {
                this.populateCacheTask(locale, cacheItem);
            }
            this.logger.debug("Find pattern from cache for locale [{}]!", (Object)locale);
            return cacheItem;
        }
        cacheItem = new PatternCacheItem();
        this.getPatternsFromDS(locale, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
        if (!cacheItem.getCachedData().isEmpty()) {
            formattingCacheService.addPatterns(locale, cacheItem);
            this.logger.debug("Pattern is cached for locale [{}]!\n\n", (Object)locale);
        }
        return cacheItem;
    }

    public JSONObject getPatterns(String language, String region) {
        PatternCacheItem cacheItem = this.getPatternsByLanguageRegion(language, region);
        if (!cacheItem.getCachedData().isEmpty()) {
            return new JSONObject(cacheItem.getCachedData());
        }
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        while (fallbackLocalesIter.hasNext()) {
            String fallbackLocale = fallbackLocalesIter.next().toLanguageTag();
            if (fallbackLocale.equalsIgnoreCase(new Locale(language, region).toLanguageTag())) continue;
            this.logger.info("Can't find pattern for language [{}] region [{}], look for fallback locale [{}] pattern as fallback!", new Object[]{language, region, fallbackLocale});
            cacheItem = this.getPatternsByLocale(fallbackLocale);
            if (cacheItem.getCachedData().isEmpty()) continue;
            return new JSONObject(cacheItem.getCachedData());
        }
        return null;
    }

    public PatternCacheItem getPatternsByLanguageRegion(String language, String region) {
        language = language.replace("_", "-");
        PatternCacheItem cacheItem = null;
        this.logger.debug("Look for pattern from cache for language [{}], region [{}]!", (Object)language, (Object)region);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        cacheItem = formattingCacheService.getPatterns(language, region);
        if (cacheItem != null) {
            if (cacheItem.isExpired()) {
                this.populateCacheTask(language, region, cacheItem);
            }
            this.logger.debug("Find pattern from cache for language [{}], region [{}]!", (Object)language, (Object)region);
            return cacheItem;
        }
        cacheItem = new PatternCacheItem();
        this.getPatternsFromDS(language, region, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
        if (!cacheItem.getCachedData().isEmpty()) {
            formattingCacheService.addPatterns(language, region, cacheItem);
            this.logger.debug("Pattern is cached for language [{}], region [{}]!\n\n", (Object)language, (Object)region);
        }
        return cacheItem;
    }

    private void getPatternsFromDS(String locale, PatternCacheItem cacheItem, ListIterator<DataSourceEnum> msgSourceQueueIter) {
        if (!msgSourceQueueIter.hasNext()) {
            this.logger.error(FormatUtils.format("Failed to get patterns for locale {0} from any data source", locale));
            return;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        dataSource.createPatternOpt().getPatterns(locale, cacheItem);
        if (cacheItem.getCachedData().isEmpty()) {
            this.logger.warn(FormatUtils.format("Failed to get patterns for locale {0} from {1} data source", locale, dataSource.toString()));
            this.getPatternsFromDS(locale, cacheItem, msgSourceQueueIter);
        }
    }

    private void getPatternsFromDS(String language, String region, PatternCacheItem cacheItem, ListIterator<DataSourceEnum> msgSourceQueueIter) {
        if (!msgSourceQueueIter.hasNext()) {
            this.logger.error(FormatUtils.format("Failed to get patterns for language {0}, region {1} from any data source", language, region));
            return;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        dataSource.createPatternOpt().getPatterns(language, region, cacheItem);
        if (cacheItem.getCachedData().isEmpty()) {
            this.logger.warn(FormatUtils.format("Failed to get patterns for language {0}, region {1} from {2} data source", language, region, dataSource.toString()));
            this.getPatternsFromDS(language, region, cacheItem, msgSourceQueueIter);
        }
    }

    private void populateCacheTask(String locale, PatternCacheItem cacheItem) {
        Runnable runnable = () -> {
            try {
                this.getPatternsFromDS(locale, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void populateCacheTask(String language, String region, PatternCacheItem cacheItem) {
        Runnable runnable = () -> {
            try {
                this.getPatternsFromDS(language, region, cacheItem, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

