/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.util;

import com.vmware.vipclient.i18n.VIPCfg;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatUtils {
    static Logger logger = LoggerFactory.getLogger(FormatUtils.class);

    private FormatUtils() {
    }

    public static String format(String pattern, Object ... arguments) {
        String escaped = pattern.replaceAll("'", "''");
        return MessageFormat.format(escaped, arguments);
    }

    private static String formatWithArrayArgs(String pattern, Locale locale, Object[] arguments) {
        if (arguments.length > 0) {
            com.vmware.vipclient.i18n.l2.text.MessageFormat messageFormat = new com.vmware.vipclient.i18n.l2.text.MessageFormat(pattern, locale);
            return messageFormat.format(arguments, new StringBuilder(), new FieldPosition(0)).toString();
        }
        return pattern;
    }

    private static String formatWithNamedArgs(String pattern, Locale locale, Map<String, Object> arguments) {
        if (arguments.size() > 0) {
            com.vmware.vipclient.i18n.l2.text.MessageFormat messageFormat = new com.vmware.vipclient.i18n.l2.text.MessageFormat(pattern, locale);
            return messageFormat.format(arguments, new StringBuilder(), new FieldPosition(0)).toString();
        }
        return pattern;
    }

    public static String formatMsg(String pattern, Locale locale, Object argument) {
        if (pattern == null || pattern.isEmpty() || argument == null) {
            return pattern;
        }
        if (argument instanceof Map) {
            return FormatUtils.formatWithNamedArgs(pattern, locale, (Map)argument);
        }
        if (argument instanceof Object[]) {
            return FormatUtils.formatWithArrayArgs(pattern, locale, (Object[])argument);
        }
        return pattern;
    }

    public static String format(String pattern, Locale locale, Object ... arguments) {
        try {
            com.vmware.vipclient.i18n.l2.text.MessageFormat messageFormat = new com.vmware.vipclient.i18n.l2.text.MessageFormat(pattern, locale);
            pattern = messageFormat.format(arguments, new StringBuilder(), new FieldPosition(0)).toString();
            if (VIPCfg.getInstance().isPseudo() && pattern != null && !pattern.startsWith("#@")) {
                pattern = "@@" + pattern + "@@";
            }
            return pattern;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return pattern;
        }
    }
}

