/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.cloudtrail;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.volcengine.ApiCallback;
import com.volcengine.ApiClient;
import com.volcengine.ApiException;
import com.volcengine.ApiResponse;
import com.volcengine.Configuration;
import com.volcengine.ProgressRequestBody;
import com.volcengine.ProgressResponseBody;
import com.volcengine.cloudtrail.model.LookupEventsRequest;
import com.volcengine.cloudtrail.model.LookupEventsResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.validation.constraints.NotNull;

public class CloudTrailApi {
    private ApiClient apiClient;

    public CloudTrailApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CloudTrailApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call lookupEventsCall(LookupEventsRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LookupEventsRequest localVarPostBody = body;
        String localVarPath = "/LookupEvents/2021-09-01/cloud_trail/post/application_json/";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"volcengineSign"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener, new boolean[0]);
    }

    private Call lookupEventsValidateBeforeCall(LookupEventsRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling lookupEvents(Async)");
        }
        Call call = this.lookupEventsCall(body, progressListener, progressRequestListener);
        return call;
    }

    public LookupEventsResponse lookupEvents(LookupEventsRequest body) throws ApiException {
        ApiResponse<LookupEventsResponse> resp = this.lookupEventsWithHttpInfo(body);
        return (LookupEventsResponse)((Object)resp.getData());
    }

    public ApiResponse<LookupEventsResponse> lookupEventsWithHttpInfo(@NotNull LookupEventsRequest body) throws ApiException {
        Call call = this.lookupEventsValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<LookupEventsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, new boolean[0]);
    }

    public Call lookupEventsAsync(LookupEventsRequest body, final ApiCallback<LookupEventsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.lookupEventsValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LookupEventsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

