/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.api.agent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.wavefront.api.agent.SshTargetDTO;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.api.agent.WorkUnit;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AgentConfiguration {
    public String name;
    public String defaultUsername;
    public String defaultPublicKey;
    public boolean allowAnyHostKeys;
    public Long currentTime;
    private List<SshTargetDTO> targets;
    private List<WorkUnit> workUnits;
    private Boolean collectorSetsPointsPerBatch;
    private Long pointsPerBatch;
    private Boolean collectorSetsRetryBackoff;
    private Double retryBackoffBaseSeconds;
    private Boolean collectorSetsRateLimit;
    private Long collectorRateLimit;
    private Long histogramRateLimit;
    private Long spanRateLimit;
    private Long spanLogsRateLimit;
    private Boolean shutOffAgents = false;
    private Boolean showTrialExpired = false;
    private Boolean histogramDisabled;
    private Boolean traceDisabled;
    private Boolean spanLogsDisabled;
    private ValidationConfiguration validationConfiguration;
    private Long globalCollectorRateLimit;
    private Long globalHistogramRateLimit;
    private Long globalSpanRateLimit;
    private Long globalSpanLogsRateLimit;
    private Integer histogramStorageAccuracy;

    public Boolean getCollectorSetsRetryBackoff() {
        return this.collectorSetsRetryBackoff;
    }

    public void setCollectorSetsRetryBackoff(Boolean collectorSetsRetryBackoff) {
        this.collectorSetsRetryBackoff = collectorSetsRetryBackoff;
    }

    public Double getRetryBackoffBaseSeconds() {
        return this.retryBackoffBaseSeconds;
    }

    public void setRetryBackoffBaseSeconds(Double retryBackoffBaseSeconds) {
        this.retryBackoffBaseSeconds = retryBackoffBaseSeconds;
    }

    public Boolean getCollectorSetsRateLimit() {
        return this.collectorSetsRateLimit;
    }

    public void setCollectorSetsRateLimit(Boolean collectorSetsRateLimit) {
        this.collectorSetsRateLimit = collectorSetsRateLimit;
    }

    public Long getCollectorRateLimit() {
        return this.collectorRateLimit;
    }

    public void setCollectorRateLimit(Long collectorRateLimit) {
        this.collectorRateLimit = collectorRateLimit;
    }

    public Long getHistogramRateLimit() {
        return this.histogramRateLimit;
    }

    public void setHistogramRateLimit(Long histogramRateLimit) {
        this.histogramRateLimit = histogramRateLimit;
    }

    public Long getSpanRateLimit() {
        return this.spanRateLimit;
    }

    public void setSpanRateLimit(Long spanRateLimit) {
        this.spanRateLimit = spanRateLimit;
    }

    public Long getSpanLogsRateLimit() {
        return this.spanLogsRateLimit;
    }

    public void setSpanLogsRateLimit(Long spanLogsRateLimit) {
        this.spanLogsRateLimit = spanLogsRateLimit;
    }

    public List<WorkUnit> getWorkUnits() {
        if (this.workUnits == null) {
            return Collections.emptyList();
        }
        return this.workUnits;
    }

    public List<SshTargetDTO> getTargets() {
        if (this.targets == null) {
            return Collections.emptyList();
        }
        return this.targets;
    }

    public void setCollectorSetsPointsPerBatch(Boolean collectorSetsPointsPerBatch) {
        this.collectorSetsPointsPerBatch = collectorSetsPointsPerBatch;
    }

    public Boolean getCollectorSetsPointsPerBatch() {
        return this.collectorSetsPointsPerBatch;
    }

    public void setTargets(List<SshTargetDTO> targets) {
        this.targets = targets;
    }

    public void setWorkUnits(List<WorkUnit> workUnits) {
        this.workUnits = workUnits;
    }

    public Long getPointsPerBatch() {
        return this.pointsPerBatch;
    }

    public void setPointsPerBatch(Long pointsPerBatch) {
        this.pointsPerBatch = pointsPerBatch;
    }

    public Boolean getShutOffAgents() {
        return this.shutOffAgents;
    }

    public void setShutOffAgents(Boolean shutOffAgents) {
        this.shutOffAgents = shutOffAgents;
    }

    public Boolean getShowTrialExpired() {
        return this.showTrialExpired;
    }

    public void setShowTrialExpired(Boolean trialExpired) {
        this.showTrialExpired = trialExpired;
    }

    public Boolean getHistogramDisabled() {
        return this.histogramDisabled;
    }

    public void setHistogramDisabled(Boolean histogramDisabled) {
        this.histogramDisabled = histogramDisabled;
    }

    public Boolean getTraceDisabled() {
        return this.traceDisabled;
    }

    public void setTraceDisabled(Boolean traceDisabled) {
        this.traceDisabled = traceDisabled;
    }

    public ValidationConfiguration getValidationConfiguration() {
        return this.validationConfiguration;
    }

    public void setValidationConfiguration(ValidationConfiguration value) {
        this.validationConfiguration = value;
    }

    public Boolean getSpanLogsDisabled() {
        return this.spanLogsDisabled;
    }

    public void setSpanLogsDisabled(Boolean spanLogsDisabled) {
        this.spanLogsDisabled = spanLogsDisabled;
    }

    public Long getGlobalCollectorRateLimit() {
        return this.globalCollectorRateLimit;
    }

    public void setGlobalCollectorRateLimit(Long globalCollectorRateLimit) {
        this.globalCollectorRateLimit = globalCollectorRateLimit;
    }

    public Long getGlobalHistogramRateLimit() {
        return this.globalHistogramRateLimit;
    }

    public void setGlobalHistogramRateLimit(Long globalHistogramRateLimit) {
        this.globalHistogramRateLimit = globalHistogramRateLimit;
    }

    public Long getGlobalSpanRateLimit() {
        return this.globalSpanRateLimit;
    }

    public void setGlobalSpanRateLimit(Long globalSpanRateLimit) {
        this.globalSpanRateLimit = globalSpanRateLimit;
    }

    public Long getGlobalSpanLogsRateLimit() {
        return this.globalSpanLogsRateLimit;
    }

    public void setGlobalSpanLogsRateLimit(Long globalSpanLogsRateLimit) {
        this.globalSpanLogsRateLimit = globalSpanLogsRateLimit;
    }

    public Integer getHistogramStorageAccuracy() {
        return this.histogramStorageAccuracy;
    }

    public void setHistogramStorageAccuracy(Integer histogramStorageAccuracy) {
        this.histogramStorageAccuracy = histogramStorageAccuracy;
    }

    public void validate(boolean local) {
        HashSet knownHostUUIDs = Collections.emptySet();
        if (this.targets != null) {
            if (this.defaultPublicKey != null) {
                Preconditions.checkArgument((boolean)new File(this.defaultPublicKey).exists(), (Object)"defaultPublicKey does not exist");
            }
            knownHostUUIDs = Sets.newHashSetWithExpectedSize((int)this.targets.size());
            for (SshTargetDTO target : this.targets) {
                Preconditions.checkNotNull((Object)target, (Object)"target cannot be null");
                target.validate(this);
                Preconditions.checkState((boolean)knownHostUUIDs.add(target.id), (Object)("duplicate target id: " + target.id));
                if (target.user == null) {
                    Preconditions.checkNotNull((Object)this.defaultUsername, (Object)("must have default username if user is not specified, host entry: " + target.host));
                }
                if (target.publicKey == null) {
                    Preconditions.checkNotNull((Object)this.defaultPublicKey, (Object)("must have default publickey if publicKey is not specified, host entry: " + target.host));
                }
                if (this.allowAnyHostKeys) continue;
                Preconditions.checkNotNull((Object)target.hostKey, (Object)("must specify hostKey if 'allowAnyHostKeys' is set to false, host entry: " + target.host));
            }
        }
        if (this.workUnits != null) {
            for (WorkUnit unit : this.workUnits) {
                Preconditions.checkNotNull((Object)unit, (Object)"workUnit cannot be null");
                unit.validate();
                if (local) continue;
                Preconditions.checkState((boolean)knownHostUUIDs.containsAll(unit.targets), (Object)("workUnit: " + unit.name + " refers to a target host that does not exist"));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentConfiguration that = (AgentConfiguration)o;
        if (this.allowAnyHostKeys != that.allowAnyHostKeys) {
            return false;
        }
        if (this.defaultPublicKey != null ? !this.defaultPublicKey.equals(that.defaultPublicKey) : that.defaultPublicKey != null) {
            return false;
        }
        if (this.defaultUsername != null ? !this.defaultUsername.equals(that.defaultUsername) : that.defaultUsername != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) {
            return false;
        }
        return !(this.workUnits != null ? !this.workUnits.equals(that.workUnits) : that.workUnits != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.defaultUsername != null ? this.defaultUsername.hashCode() : 0);
        result = 31 * result + (this.defaultPublicKey != null ? this.defaultPublicKey.hashCode() : 0);
        result = 31 * result + (this.allowAnyHostKeys ? 1 : 0);
        result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
        result = 31 * result + (this.workUnits != null ? this.workUnits.hashCode() : 0);
        return result;
    }
}

