/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.ImmutableSet;
import com.wavefront.ingester.AbstractIngesterFormatter;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.antlr.v4.runtime.Token;
import wavefront.report.ReportSourceTag;

public class ReportSourceTagIngesterFormatter
extends AbstractIngesterFormatter<ReportSourceTag> {
    static final String SOURCE = "source";
    static final String DESCRIPTION = "description";
    static final String ACTION = "action";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_DELETE = "delete";
    static final Set<String> VALID_ACTIONS = ImmutableSet.of((Object)"add", (Object)"save", (Object)"delete");

    private ReportSourceTagIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement> elements) {
        super(elements);
    }

    public static SourceTagIngesterFormatBuilder newBuilder() {
        return new SourceTagIngesterFormatBuilder();
    }

    @Override
    public ReportSourceTag drive(String input, String defaultHostName, String customerId, List<String> customerSourceTags) {
        Queue<Token> queue = this.getQueue(input);
        ReportSourceTag sourceTag = new ReportSourceTag();
        AbstractIngesterFormatter.ReportSourceTagWrapper wrapper = new AbstractIngesterFormatter.ReportSourceTagWrapper(sourceTag);
        try {
            for (Object element : this.elements) {
                element.consume(queue, wrapper);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        Map<String, String> annotations = wrapper.getAnnotationMap();
        block13: for (Map.Entry entry : annotations.entrySet()) {
            switch ((String)entry.getKey()) {
                case "action": {
                    sourceTag.setAction((String)entry.getValue());
                    continue block13;
                }
                case "source": {
                    sourceTag.setSource((String)entry.getValue());
                    continue block13;
                }
                case "description": {
                    sourceTag.setDescription((String)entry.getValue());
                    continue block13;
                }
            }
            throw new RuntimeException("Unknown tag key = " + (String)entry.getKey() + " specified.");
        }
        if (sourceTag.getSource() == null) {
            throw new RuntimeException("No source key was present in the input: " + input);
        }
        String action = sourceTag.getAction();
        if (action == null) {
            throw new RuntimeException("No action key was present in the input: " + input);
        }
        if (!VALID_ACTIONS.contains(action)) {
            throw new RuntimeException("Action string did not match save/delete: " + input);
        }
        if (sourceTag.getSourceTagLiteral().equals("SourceTag") && sourceTag.getAnnotations() == null) {
            throw new RuntimeException("No tag(s) provided for action type `" + action + "`");
        }
        return ReportSourceTag.newBuilder(sourceTag).build();
    }

    public static class SourceTagIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportSourceTag> {
        public ReportSourceTagIngesterFormatter build() {
            return new ReportSourceTagIngesterFormatter(this.elements);
        }
    }
}

