/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.ImmutableList;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.ReportSourceTagIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.List;
import wavefront.report.ReportSourceTag;
import wavefront.report.SourceTagAction;

public class ReportSourceTagDecoder
implements ReportableEntityDecoder<String, ReportSourceTag> {
    private static final AbstractIngesterFormatter<ReportSourceTag> FORMAT = ReportSourceTagIngesterFormatter.newBuilder().whiteSpace().appendCaseSensitiveLiterals(new String[]{"@SourceTag", "@SourceDescription"}).whiteSpace().appendLoopOfKeywords().whiteSpace().appendLoopOfValues().build();

    @Override
    public void decode(String msg, List<ReportSourceTag> out, String customerId) {
        ReportSourceTag tag = FORMAT.drive(msg, "dummy", customerId, null);
        if (out == null) {
            return;
        }
        if ((tag.getAction() == SourceTagAction.ADD || tag.getAction() == SourceTagAction.DELETE) && tag.getAnnotations().size() > 1) {
            tag.getAnnotations().forEach(x -> out.add(ReportSourceTag.newBuilder(tag).setAnnotations((List<String>)ImmutableList.of((Object)x)).build()));
        } else {
            out.add(tag);
        }
    }
}

