/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.common.SerializerUtils;
import java.util.List;
import java.util.function.Function;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;

public class ReportPointSerializer
implements Function<ReportPoint, String> {
    @Override
    public String apply(ReportPoint point) {
        return ReportPointSerializer.pointToString(point);
    }

    private static void appendCompactedCentroids(StringBuilder sb, List<Double> bins, List<Integer> counts) {
        int numCentroids = Math.min(bins.size(), counts.size());
        Double accumulatedValue = null;
        int accumulatedCount = 0;
        for (int i = 0; i < numCentroids; ++i) {
            double value = bins.get(i);
            int count = counts.get(i);
            if (accumulatedValue != null && value != accumulatedValue) {
                sb.append('#').append(accumulatedCount).append(' ');
                sb.append(accumulatedValue).append(' ');
                accumulatedValue = value;
                accumulatedCount = count;
                continue;
            }
            if (accumulatedValue == null) {
                accumulatedValue = value;
            }
            accumulatedCount += count;
        }
        if (accumulatedValue != null) {
            sb.append('#').append(accumulatedCount).append(' ');
            sb.append(accumulatedValue).append(' ');
        }
    }

    @VisibleForTesting
    public static String pointToString(ReportPoint point) {
        if (point.getValue() instanceof Number || point.getValue() instanceof String) {
            StringBuilder sb = new StringBuilder(80);
            SerializerUtils.appendQuoted(sb, point.getMetric()).append(" ").append(point.getValue()).append(" ").append(point.getTimestamp() / 1000L).append(" ").append("source=");
            SerializerUtils.appendQuoted(sb, point.getHost());
            SerializerUtils.appendTagMap(sb, point.getAnnotations());
            return sb.toString();
        }
        if (point.getValue() instanceof Histogram) {
            Histogram h = (Histogram)((Object)point.getValue());
            StringBuilder sb = new StringBuilder();
            switch (h.getDuration()) {
                case 60000: {
                    sb.append("!M ");
                    break;
                }
                case 3600000: {
                    sb.append("!H ");
                    break;
                }
                case 86400000: {
                    sb.append("!D ");
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected histogram duration " + h.getDuration());
                }
            }
            sb.append(point.getTimestamp() / 1000L).append(' ');
            ReportPointSerializer.appendCompactedCentroids(sb, h.getBins(), h.getCounts());
            SerializerUtils.appendQuoted(sb, point.getMetric());
            sb.append(" ").append("source=");
            SerializerUtils.appendQuoted(sb, point.getHost());
            SerializerUtils.appendTagMap(sb, point.getAnnotations());
            return sb.toString();
        }
        throw new RuntimeException("Unsupported value class: " + point.getValue().getClass().getCanonicalName());
    }
}

