/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.common.SerializerUtils;
import java.util.function.Function;
import wavefront.report.ReportMetric;

public class ReportMetricSerializer
implements Function<ReportMetric, String> {
    @Override
    public String apply(ReportMetric point) {
        return ReportMetricSerializer.metricToString(point);
    }

    @VisibleForTesting
    public static String metricToString(ReportMetric point) {
        StringBuilder sb = new StringBuilder(80);
        SerializerUtils.appendQuoted(sb, point.getMetric()).append(" ").append(point.getValue()).append(" ").append(point.getTimestamp() / 1000L).append(" ").append("source=");
        SerializerUtils.appendQuoted(sb, point.getHost());
        SerializerUtils.appendAnnotations(sb, point.getAnnotations());
        return sb.toString();
    }
}

