/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.common.SerializerUtils;
import com.wavefront.data.DataValidationException;
import java.util.List;
import java.util.function.Function;
import wavefront.report.Histogram;
import wavefront.report.ReportHistogram;

public class ReportHistogramSerializer
implements Function<ReportHistogram, String> {
    @Override
    public String apply(ReportHistogram point) {
        return ReportHistogramSerializer.histogramToString(point);
    }

    private static void appendCompactedCentroids(StringBuilder sb, List<Double> bins, List<Integer> counts) {
        int numCentroids = Math.min(bins.size(), counts.size());
        Double accumulatedValue = null;
        int accumulatedCount = 0;
        for (int i = 0; i < numCentroids; ++i) {
            double value = bins.get(i);
            int count = counts.get(i);
            if (accumulatedValue != null && value != accumulatedValue) {
                sb.append('#').append(accumulatedCount).append(' ');
                sb.append(accumulatedValue).append(' ');
                accumulatedValue = value;
                accumulatedCount = count;
                continue;
            }
            if (accumulatedValue == null) {
                accumulatedValue = value;
            }
            accumulatedCount += count;
        }
        if (accumulatedValue != null) {
            sb.append('#').append(accumulatedCount).append(' ');
            sb.append(accumulatedValue).append(' ');
        }
    }

    @VisibleForTesting
    public static String histogramToString(ReportHistogram point) {
        Histogram h = point.getValue();
        StringBuilder sb = new StringBuilder();
        switch (h.getDuration()) {
            case 60000: {
                sb.append("!M ");
                break;
            }
            case 3600000: {
                sb.append("!H ");
                break;
            }
            case 86400000: {
                sb.append("!D ");
                break;
            }
            default: {
                throw new DataValidationException("Unexpected histogram duration " + h.getDuration());
            }
        }
        sb.append(point.getTimestamp() / 1000L).append(' ');
        ReportHistogramSerializer.appendCompactedCentroids(sb, h.getBins(), h.getCounts());
        SerializerUtils.appendQuoted(sb, point.getMetric());
        sb.append(" ").append("source=");
        SerializerUtils.appendQuoted(sb, point.getHost());
        SerializerUtils.appendAnnotations(sb, point.getAnnotations());
        return sb.toString();
    }
}

