/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.api.agent;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.wavefront.api.agent.SshTargetDTO;
import com.wavefront.api.agent.WorkUnit;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class AgentConfiguration {
    public String name;
    public String defaultUsername;
    public String defaultPublicKey;
    public boolean allowAnyHostKeys;
    public Long currentTime;
    private List<SshTargetDTO> targets;
    private List<WorkUnit> workUnits;

    public List<WorkUnit> getWorkUnits() {
        if (this.workUnits == null) {
            return Collections.emptyList();
        }
        return this.workUnits;
    }

    public List<SshTargetDTO> getTargets() {
        if (this.targets == null) {
            return Collections.emptyList();
        }
        return this.targets;
    }

    public void setTargets(List<SshTargetDTO> targets) {
        this.targets = targets;
    }

    public void setWorkUnits(List<WorkUnit> workUnits) {
        this.workUnits = workUnits;
    }

    public void validate(boolean local) {
        HashSet knownHostUUIDs = Collections.emptySet();
        if (this.targets != null) {
            if (this.defaultPublicKey != null) {
                Preconditions.checkArgument((boolean)new File(this.defaultPublicKey).exists(), (Object)"defaultPublicKey does not exist");
            }
            knownHostUUIDs = Sets.newHashSetWithExpectedSize((int)this.targets.size());
            for (SshTargetDTO target : this.targets) {
                Preconditions.checkNotNull((Object)target, (Object)"target cannot be null");
                target.validate(this);
                Preconditions.checkState((boolean)knownHostUUIDs.add(target.id), (Object)("duplicate target id: " + target.id));
                if (target.user == null) {
                    Preconditions.checkNotNull((Object)this.defaultUsername, (Object)("must have default username if user is not specified, host entry: " + target.host));
                }
                if (target.publicKey == null) {
                    Preconditions.checkNotNull((Object)this.defaultPublicKey, (Object)("must have default publickey if publicKey is not specified, host entry: " + target.host));
                }
                if (this.allowAnyHostKeys) continue;
                Preconditions.checkNotNull((Object)target.hostKey, (Object)("must specify hostKey if 'allowAnyHostKeys' is set to false, host entry: " + target.host));
            }
        }
        if (this.workUnits != null) {
            for (WorkUnit unit : this.workUnits) {
                Preconditions.checkNotNull((Object)unit, (Object)"workUnit cannot be null");
                unit.validate();
                if (local) continue;
                Preconditions.checkState((boolean)knownHostUUIDs.containsAll(unit.targets), (Object)("workUnit: " + unit.name + " refers to a target host that does not exist"));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentConfiguration that = (AgentConfiguration)o;
        if (this.allowAnyHostKeys != that.allowAnyHostKeys) {
            return false;
        }
        if (this.defaultPublicKey != null ? !this.defaultPublicKey.equals(that.defaultPublicKey) : that.defaultPublicKey != null) {
            return false;
        }
        if (this.defaultUsername != null ? !this.defaultUsername.equals(that.defaultUsername) : that.defaultUsername != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) {
            return false;
        }
        return !(this.workUnits != null ? !this.workUnits.equals(that.workUnits) : that.workUnits != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.defaultUsername != null ? this.defaultUsername.hashCode() : 0);
        result = 31 * result + (this.defaultPublicKey != null ? this.defaultPublicKey.hashCode() : 0);
        result = 31 * result + (this.allowAnyHostKeys ? 1 : 0);
        result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
        result = 31 * result + (this.workUnits != null ? this.workUnits.hashCode() : 0);
        return result;
    }
}

