/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester.graphite;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import queryserver.parser.DSWrapperLexer;
import sunnylabs.report.ReportPoint;

public class GraphiteDecoder
extends MessageToMessageDecoder<String> {
    private static final Pattern CUSTOMERID = Pattern.compile("[a-z]+");
    private final String hostName;

    public GraphiteDecoder() {
        this.hostName = null;
    }

    public GraphiteDecoder(String hostName) {
        this.hostName = hostName;
    }

    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId) {
        DSWrapperLexer lexer = new DSWrapperLexer((CharStream)new ANTLRInputStream(msg));
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new RuntimeException(msg, (Throwable)e);
            }
        });
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        commonTokenStream.getText();
        List tokens = commonTokenStream.getTokens();
        if (tokens.isEmpty()) {
            throw new RuntimeException("Could not parse: " + msg);
        }
        ArrayDeque<Token> queue = new ArrayDeque<Token>(Lists.newArrayList((Iterable)Iterables.filter((Iterable)tokens, (Predicate)new Predicate<Token>(){

            public boolean apply(Token input) {
                return input.getType() != -1;
            }
        })));
        this.skipWhiteSpace(queue);
        String metric = this.getLiteral(queue);
        if (metric.length() == 0) {
            throw new RuntimeException("Invalid metric name in line: " + msg);
        }
        this.skipWhiteSpace(queue);
        Token current = (Token)queue.poll();
        String value = "";
        if (current.getType() == 4) {
            current = (Token)queue.poll();
            value = "-";
        }
        if (current.getType() == 8) {
            if (!value.equals("")) {
                throw new RuntimeException("invalid metric value: " + value + current.getText());
            }
            value = value + GraphiteDecoder.unquote(current.getText());
        } else if (current.getType() == 7 || current.getType() == 9 || current.getType() == 6) {
            value = value + current.getText();
        } else {
            throw new RuntimeException("invalid metric value: " + current.getText());
        }
        this.skipWhiteSpace(queue);
        current = (Token)queue.peek();
        HashMap annotations = Maps.newHashMap();
        String timestamp = null;
        if (current != null) {
            if (current.getType() == 6) {
                timestamp = ((Token)queue.poll()).getText();
                this.skipWhiteSpace(queue);
            }
            String tagk = null;
            while (!queue.isEmpty()) {
                if (tagk == null) {
                    tagk = this.getLiteral(queue);
                    if (tagk.length() == 0) {
                        throw new RuntimeException("Invalid tag name: " + msg);
                    }
                    this.skipWhiteSpace(queue);
                    current = (Token)queue.poll();
                    if (current == null || current.getType() != 1) {
                        throw new RuntimeException("Tag keys and values must be separated by '='" + (current != null ? ", found: " + current.getText() : ", found EOF"));
                    }
                } else {
                    String tagv = this.getLiteral(queue);
                    if (tagv.length() == 0) {
                        throw new RuntimeException("Invalid tag value: " + msg);
                    }
                    annotations.put(tagk, tagv);
                    tagk = null;
                }
                this.skipWhiteSpace(queue);
            }
        }
        ReportPoint.Builder builder = ReportPoint.newBuilder();
        try {
            builder.setValue(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            builder.setValue(value);
        }
        String host = (String)annotations.remove("source");
        if (host == null) {
            host = (String)annotations.remove("host");
        } else if (annotations.containsKey("host")) {
            annotations.put("_host", annotations.remove("host"));
        }
        if (host == null) {
            host = this.hostName;
        }
        if (annotations.containsKey("tag")) {
            String tagV = (String)annotations.remove("tag");
            annotations.put("_tag", tagV);
        }
        ReportPoint point = builder.setMetric(metric).setTable(customerId).setAnnotations(annotations).setHost(host).setTimestamp(timestamp == null ? System.currentTimeMillis() : (long)(1000.0 * Double.parseDouble(timestamp))).build();
        if (out != null) {
            out.add(point);
        }
    }

    private String getLiteral(Queue<Token> tokens) {
        String toReturn = "";
        Token next = tokens.peek();
        if (next == null) {
            return "";
        }
        if (next.getType() == 8) {
            return GraphiteDecoder.unquote(tokens.poll().getText());
        }
        while (next != null && (next.getType() == 7 || next.getType() == 6 || next.getType() == 9 || next.getType() == 3 || next.getType() == 4 || next.getType() == 5)) {
            toReturn = toReturn + tokens.poll().getText();
            next = tokens.peek();
        }
        return toReturn;
    }

    private void skipWhiteSpace(Queue<Token> tokens) {
        while (!tokens.isEmpty() && tokens.peek().getType() == 12) {
            tokens.poll();
        }
    }

    public void decodeReportPoints(String msg, List<ReportPoint> out) {
        ArrayList output = Lists.newArrayList();
        this.decodeReportPoints(msg, output, "dummy");
        if (!output.isEmpty()) {
            for (ReportPoint rp : output) {
                String metricName = rp.getMetric();
                ArrayList metricParts = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)metricName));
                if (metricParts.size() <= 1) {
                    throw new RuntimeException("Metric name does not contain a customer id: " + metricName);
                }
                String customerId = (String)metricParts.get(0);
                if (CUSTOMERID.matcher(customerId).matches()) {
                    metricName = Joiner.on((String)".").join(metricParts.subList(1, metricParts.size()));
                }
                out.add(ReportPoint.newBuilder(rp).setMetric(metricName).setTable(customerId).build());
            }
        }
    }

    public void decode(ChannelHandlerContext ctx, String msg, List<Object> out) throws Exception {
        ArrayList points = Lists.newArrayList();
        this.decodeReportPoints(msg, points);
        out.addAll(points);
    }

    public static String unquote(String text) {
        if (text.startsWith("\"")) {
            text = text.substring(1, text.length() - 1).replace("\\\"", "\"");
        } else if (text.startsWith("'")) {
            text = text.substring(1, text.length() - 1).replace("\\'", "'");
        }
        return text;
    }
}

