/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GraphiteHostAnnotator
extends MessageToMessageDecoder<String> {
    private static final Pattern HOST_EXISTENCE_PATTERN = Pattern.compile("(.+)(host=[^\\s].+)", 2);
    private static final Pattern SOURCE_EXISTENCE_PATTERN = Pattern.compile("(.+)(source=[^\\s].+)", 2);
    private final String hostName;

    public GraphiteHostAnnotator(String hostName) {
        this.hostName = hostName;
    }

    protected void decode(ChannelHandlerContext ctx, String msg, List<Object> out) throws Exception {
        Matcher m = HOST_EXISTENCE_PATTERN.matcher(msg);
        if (m.matches()) {
            out.add(msg);
        } else {
            m = SOURCE_EXISTENCE_PATTERN.matcher(msg);
            if (m.matches()) {
                out.add(msg);
            } else {
                out.add(msg + " source=" + this.hostName);
            }
        }
    }
}

