/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class Ingester
implements Runnable {
    private static final Logger logger = Logger.getLogger(Ingester.class.getCanonicalName());
    private static final int CHANNEL_IDLE_TIMEOUT_IN_SECS = (int)TimeUnit.DAYS.toSeconds(1L);
    @Nullable
    private final List<Function<SocketChannel, ChannelHandler>> decoders;
    private final ChannelHandler commandHandler;
    private final int listeningPort;

    public Ingester(List<Function<SocketChannel, ChannelHandler>> decoders, ChannelHandler commandHandler, int port) {
        this.listeningPort = port;
        this.commandHandler = commandHandler;
        this.decoders = decoders;
    }

    public Ingester(ChannelHandler commandHandler, int port) {
        this.listeningPort = port;
        this.commandHandler = commandHandler;
        this.decoders = null;
    }

    @Override
    public void run() {
        ServerBootstrap b = new ServerBootstrap();
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)new NioEventLoopGroup(1), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).localAddress(this.listeningPort)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(4096, true, true)});
                    pipeline.addLast(new ChannelHandler[]{new StringDecoder(Charsets.UTF_8)});
                    if (Ingester.this.decoders != null) {
                        for (Function handler : Ingester.this.decoders) {
                            pipeline.addLast(new ChannelHandler[]{(ChannelHandler)handler.apply((Object)ch)});
                        }
                    }
                    pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(CHANNEL_IDLE_TIMEOUT_IN_SECS, 0, 0));
                    pipeline.addLast("idleChannelTerminator", (ChannelHandler)new ChannelDuplexHandler(){

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                            if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                                logger.warning("terminating connection to graphite client due to inactivity after " + CHANNEL_IDLE_TIMEOUT_IN_SECS + "s: " + ctx.channel());
                                ctx.close();
                            }
                        }
                    });
                    pipeline.addLast(new ChannelHandler[]{Ingester.this.commandHandler});
                }
            });
            ChannelFuture f = b.bind().sync();
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

