/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.wavefront.common.Pair;
import com.yammer.metrics.core.MetricName;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.management.ObjectName;
import sunnylabs.report.ReportPoint;

public class TaggedMetricName
extends MetricName {
    @Nonnull
    private final Map<String, String> tags;

    public TaggedMetricName(String group, String name) {
        super(group, "", name);
        this.tags = Collections.emptyMap();
    }

    public TaggedMetricName(String group, String name, String ... tagAndValues) {
        this(group, name, TaggedMetricName.makeTags(tagAndValues));
    }

    public TaggedMetricName(String group, String name, Map<String, String> tags) {
        this(group, name, TaggedMetricName.makeTags(tags));
    }

    public TaggedMetricName(String group, String name, Pair<String, String> ... tags) {
        super(group, "", name, null, TaggedMetricName.createMBeanName(group, "", name, tags));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Pair<String, String> tag : tags) {
            if (tag == null || tag._1 == null || tag._2 == null) continue;
            builder.put(tag._1, tag._2);
        }
        this.tags = builder.build();
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaggedMetricName that = (TaggedMetricName)((Object)o);
        return this.getTags().equals(that.getTags());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getTags().hashCode();
        return result;
    }

    public void updatePointBuilder(ReportPoint.Builder builder) {
        builder.getAnnotations().putAll(this.tags);
    }

    private static Pair<String, String>[] makeTags(Map<String, String> tags) {
        Pair[] toReturn = new Pair[tags.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            toReturn[i] = new Pair<String, String>(entry.getKey(), entry.getValue());
            ++i;
        }
        return toReturn;
    }

    private static Pair<String, String>[] makeTags(String ... tagAndValues) {
        Preconditions.checkArgument(((tagAndValues.length & 1) == 0 ? 1 : 0) != 0, (Object)"must have even number of tag values");
        Pair[] toReturn = new Pair[tagAndValues.length / 2];
        for (int i = 0; i < tagAndValues.length; i += 2) {
            String tag = tagAndValues[i];
            String value = tagAndValues[i + 1];
            if (tag == null || value == null) continue;
            toReturn[i / 2] = new Pair<String, String>(tag, value);
        }
        return toReturn;
    }

    private static String createMBeanName(String group, String type, String name, Pair<String, String> ... tags) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(ObjectName.quote(group));
        nameBuilder.append(":type=");
        nameBuilder.append(ObjectName.quote(type));
        if (name.length() > 0) {
            nameBuilder.append(",name=");
            nameBuilder.append(ObjectName.quote(name));
        }
        for (Pair<String, String> tag : tags) {
            if (tag == null) continue;
            nameBuilder.append(",");
            nameBuilder.append((String)tag._1);
            nameBuilder.append("=");
            nameBuilder.append((String)tag._2);
        }
        return nameBuilder.toString();
    }
}

