/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class StreamIngester
implements Runnable {
    protected static final Logger logger = Logger.getLogger(StreamIngester.class.getName());
    private final ChannelHandler commandHandler;
    private final int listeningPort;
    private final FrameDecoderFactory frameDecoderFactory;
    @Nullable
    protected Map<ChannelOption<?>, ?> parentChannelOptions;
    @Nullable
    protected Map<ChannelOption<?>, ?> childChannelOptions;

    public StreamIngester(FrameDecoderFactory frameDecoderFactory, ChannelHandler commandHandler, int port) {
        this.listeningPort = port;
        this.commandHandler = commandHandler;
        this.frameDecoderFactory = frameDecoderFactory;
    }

    public StreamIngester withParentChannelOptions(Map<ChannelOption<?>, ?> parentChannelOptions) {
        this.parentChannelOptions = parentChannelOptions;
        return this;
    }

    public StreamIngester withChildChannelOptions(Map<ChannelOption<?>, ?> childChannelOptions) {
        this.childChannelOptions = childChannelOptions;
        return this;
    }

    @Override
    public void run() {
        ServerBootstrap b = new ServerBootstrap();
        NioEventLoopGroup parentGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup childGroup = new NioEventLoopGroup();
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)parentGroup, (EventLoopGroup)childGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).localAddress(this.listeningPort)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("frame decoder", (ChannelHandler)StreamIngester.this.frameDecoderFactory.getDecoder());
                    pipeline.addLast("byte array decoder", (ChannelHandler)new ByteArrayDecoder());
                    pipeline.addLast(new ChannelHandler[]{StreamIngester.this.commandHandler});
                }
            });
            if (this.parentChannelOptions != null) {
                for (Map.Entry<ChannelOption<?>, ?> entry : this.parentChannelOptions.entrySet()) {
                    b.option(entry.getKey(), entry.getValue());
                }
            }
            if (this.childChannelOptions != null) {
                for (Map.Entry<ChannelOption<?>, ?> entry : this.childChannelOptions.entrySet()) {
                    b.childOption(entry.getKey(), entry.getValue());
                }
            }
            ChannelFuture f = b.bind().sync();
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Interrupted");
            parentGroup.shutdownGracefully();
            childGroup.shutdownGracefully();
            logger.info("Listener on port " + String.valueOf(this.listeningPort) + " shut down");
        }
    }

    public static interface FrameDecoderFactory {
        public ChannelInboundHandler getDecoder();
    }
}

