/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.google.common.base.Predicate;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class MetricWhiteBlackList
implements Predicate<String> {
    @Nullable
    private final Pattern pointLineWhiteList;
    @Nullable
    private final Pattern pointLineBlackList;
    private final Counter regexRejects;

    public MetricWhiteBlackList(@Nullable String pointLineWhiteListRegex, @Nullable String pointLineBlackListRegex, String portName) {
        this.pointLineWhiteList = !StringUtils.isBlank((String)pointLineWhiteListRegex) ? Pattern.compile(pointLineWhiteListRegex) : null;
        this.pointLineBlackList = !StringUtils.isBlank((String)pointLineBlackListRegex) ? Pattern.compile(pointLineBlackListRegex) : null;
        this.regexRejects = Metrics.newCounter((MetricName)new TaggedMetricName("validationRegex", "points-rejected", "port", portName));
    }

    public boolean apply(String pointLine) {
        if (this.pointLineWhiteList != null && !this.pointLineWhiteList.matcher(pointLine).matches() || this.pointLineBlackList != null && this.pointLineBlackList.matcher(pointLine).matches()) {
            this.regexRejects.inc();
            return false;
        }
        return true;
    }
}

