/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import org.antlr.v4.runtime.Token;
import wavefront.report.ReportSourceTag;

public class SourceTagIngesterFormatter<T extends ReportSourceTag>
extends AbstractIngesterFormatter<T> {
    private static final Logger logger = Logger.getLogger(SourceTagIngesterFormatter.class.getCanonicalName());
    public static final String SOURCE = "source";
    public static final String DESCRIPTION = "description";
    public static final String ACTION = "action";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_DELETE = "delete";

    private SourceTagIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement> elements) {
        super(elements);
    }

    public static SourceTagIngesterFormatBuilder newBuilder() {
        return new SourceTagIngesterFormatBuilder();
    }

    @Override
    public T drive(String input, String defaultHostName, String customerId, List<String> customerSourceTags) {
        Queue<Token> queue = this.getQueue(input);
        ReportSourceTag sourceTag = new ReportSourceTag();
        AbstractIngesterFormatter.ReportSourceTagWrapper wrapper = new AbstractIngesterFormatter.ReportSourceTagWrapper(sourceTag);
        try {
            for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
                element.consume(queue, wrapper);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        if (sourceTag.getSource() == null) {
            throw new RuntimeException("No source key was present in the input: " + input);
        }
        if (sourceTag.getAction() != null) {
            String actionStr = sourceTag.getAction();
            if (!actionStr.equals(ACTION_SAVE) && !actionStr.equals(ACTION_DELETE)) {
                throw new RuntimeException("Action string did not match save/delete: " + input);
            }
        } else {
            throw new RuntimeException("No action key was present in the input: " + input);
        }
        return (T)((Object)sourceTag);
    }

    public static class SourceTagIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder {
        @Override
        public SourceTagIngesterFormatter build() {
            return new SourceTagIngesterFormatter(this.elements);
        }
    }
}

