/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GraphiteHostAnnotator
extends MessageToMessageDecoder<String> {
    private final String hostName;
    private final List<String> sourceTags = new ArrayList<String>();

    public GraphiteHostAnnotator(String hostName, List<String> customSourceTags) {
        this.hostName = hostName;
        this.sourceTags.add("source=");
        this.sourceTags.add("host=");
        this.sourceTags.addAll(customSourceTags.stream().map(customTag -> customTag + "=").collect(Collectors.toList()));
    }

    protected void decode(ChannelHandlerContext ctx, String msg, List<Object> out) throws Exception {
        for (String tag : this.sourceTags) {
            int strIndex = msg.indexOf(tag);
            if (strIndex <= -1 || msg.length() - strIndex - tag.length() <= 0 || msg.charAt(strIndex + tag.length()) <= ' ') continue;
            out.add(msg);
            return;
        }
        out.add(msg + " source=\"" + this.hostName + "\"");
    }
}

