/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;

public abstract class Clock {
    private static Long serverTime;
    private static Long localTime;
    private static Long clockDrift;

    public static void set(long serverTime) {
        localTime = System.currentTimeMillis();
        Clock.serverTime = serverTime;
        clockDrift = serverTime - localTime;
    }

    public static long now() {
        if (serverTime == null) {
            return System.currentTimeMillis();
        }
        return System.currentTimeMillis() - localTime + serverTime;
    }

    static {
        Metrics.newGauge((MetricName)new MetricName("clock", "", "drift"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return (long)Math.floor((double)(clockDrift / 1000L) + 0.5);
            }
        });
    }
}

