/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.google.common.collect.ImmutableMap;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import java.util.Map;

public abstract class MetricsToTimeseries {
    public static Map<String, Double> explodeSummarizable(Summarizable metric) {
        return ImmutableMap.builder().put((Object)"min", (Object)metric.min()).put((Object)"max", (Object)metric.max()).put((Object)"mean", (Object)metric.mean()).put((Object)"sum", (Object)metric.sum()).put((Object)"stddev", (Object)metric.stdDev()).build();
    }

    public static Map<String, Double> explodeSampling(Sampling sampling) {
        return ImmutableMap.builder().put((Object)"median", (Object)sampling.getSnapshot().getMedian()).put((Object)"p75", (Object)sampling.getSnapshot().get75thPercentile()).put((Object)"p95", (Object)sampling.getSnapshot().get95thPercentile()).put((Object)"p99", (Object)sampling.getSnapshot().get99thPercentile()).put((Object)"p999", (Object)sampling.getSnapshot().get999thPercentile()).build();
    }

    public static Map<String, Double> explodeMetered(Metered metered) {
        return ImmutableMap.builder().put((Object)"count", (Object)new Long(metered.count()).doubleValue()).put((Object)"mean", (Object)metered.oneMinuteRate()).put((Object)"m1", (Object)metered.oneMinuteRate()).put((Object)"m5", (Object)metered.fiveMinuteRate()).put((Object)"m15", (Object)metered.fifteenMinuteRate()).build();
    }
}

