/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients;

import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.clients.WavefrontClient;
import com.wavefront.sdk.common.clients.WavefrontMultiClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WavefrontClientFactory {
    private static final String PROXY_SCHEME = "proxy";
    private static final String HTTP_PROXY_SCHEME = "http";
    private static final String DIRECT_DATA_INGESTION_SCHEME = "https";
    private List<WavefrontSender> clients = new ArrayList<WavefrontSender>();
    private static Logger log = Logger.getLogger(WavefrontClientFactory.class.getCanonicalName());

    public WavefrontClientFactory addClient(WavefrontSender sender) {
        if (!this.existingClient(sender.getClientId())) {
            this.clients.add(sender);
        }
        return this;
    }

    public WavefrontClientFactory addClient(String url) {
        return this.addClient(url, null, null, null);
    }

    public WavefrontClientFactory addClient(String url, @Nullable Integer batchSize, @Nullable Integer maxQueueSize, @Nullable Integer flushIntervalSeconds) {
        ParsedHostString parsedHostString = this.getServerAndTokenFromEndpoint(url);
        if (this.existingClient(parsedHostString.server)) {
            throw new UnsupportedOperationException("client with id " + url + " already exists.");
        }
        WavefrontClient.Builder builder = new WavefrontClient.Builder(parsedHostString.server, parsedHostString.token);
        if (batchSize != null) {
            builder.batchSize(batchSize);
        }
        if (maxQueueSize != null) {
            builder.maxQueueSize(maxQueueSize);
        }
        if (flushIntervalSeconds != null) {
            builder.flushIntervalSeconds(flushIntervalSeconds);
        }
        this.clients.add(builder.build());
        return this;
    }

    public WavefrontSender getClient() {
        if (this.clients.size() == 0) {
            log.log(Level.WARNING, "Call to getClient without any endpoints having been specified");
            return null;
        }
        if (this.clients.size() == 1) {
            return this.clients.get(0);
        }
        WavefrontMultiClient.Builder builder = new WavefrontMultiClient.Builder();
        this.clients.forEach(builder::withWavefrontSender);
        return builder.build();
    }

    private boolean existingClient(String server) {
        return this.clients.stream().anyMatch(c -> c.getClientId().equals(server));
    }

    private ParsedHostString getServerAndTokenFromEndpoint(String endpoint) {
        String host;
        String token;
        URI uri = URI.create(endpoint);
        if (uri.getScheme().equals(DIRECT_DATA_INGESTION_SCHEME)) {
            token = uri.getUserInfo();
            host = "https://" + uri.getHost();
        } else if (uri.getScheme().equals(PROXY_SCHEME) || uri.getScheme().equals(HTTP_PROXY_SCHEME)) {
            token = null;
            host = "http://" + uri.getHost() + ":" + uri.getPort();
            if (uri.getUserInfo() != null) {
                log.log(Level.WARNING, "Attempting to send a token over clear-text, dropping token.");
            }
        } else {
            throw new RuntimeException("Unknown scheme specified while attempting to build a client " + uri.getScheme());
        }
        return new ParsedHostString(host, token);
    }

    private static class ParsedHostString {
        final String server;
        final String token;

        ParsedHostString(String server, String token) {
            this.server = server;
            this.token = token;
        }
    }
}

