/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.application;

import com.wavefront.sdk.common.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ApplicationTags {
    private final String application;
    @Nullable
    private final String cluster;
    private final String service;
    @Nullable
    private final String shard;
    private final Map<String, String> customTags;

    private ApplicationTags(Builder builder) {
        this.application = builder.application;
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.shard = builder.shard;
        this.customTags = builder.customTags;
    }

    public String getApplication() {
        return this.application;
    }

    @Nullable
    public String getCluster() {
        return this.cluster;
    }

    public String getService() {
        return this.service;
    }

    @Nullable
    public String getShard() {
        return this.shard;
    }

    @Nullable
    public Map<String, String> getCustomTags() {
        return this.customTags;
    }

    public Map<String, String> toPointTags() {
        return Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                this.put("application", ApplicationTags.this.application);
                this.put("cluster", ApplicationTags.this.cluster == null ? "none" : ApplicationTags.this.cluster);
                this.put("service", ApplicationTags.this.service);
                this.put("shard", ApplicationTags.this.shard == null ? "none" : ApplicationTags.this.shard);
                if (ApplicationTags.this.customTags != null) {
                    this.putAll(ApplicationTags.this.customTags);
                }
            }
        });
    }

    public static class Builder {
        private final String application;
        private final String service;
        @Nullable
        private String cluster;
        @Nullable
        private String shard;
        private Map<String, String> customTags = new HashMap<String, String>();

        public Builder(String application, String service) {
            this.application = application;
            this.service = service;
        }

        public Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder shard(String shard) {
            this.shard = shard;
            return this;
        }

        public Builder customTags(Map<String, String> customTags) {
            this.customTags = customTags;
            return this;
        }

        public ApplicationTags build() {
            return new ApplicationTags(this);
        }
    }
}

