/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients.service.token;

import com.wavefront.sdk.common.clients.service.token.CSPURLConnectionFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class CSPUserTokenURLConnectionFactory
implements CSPURLConnectionFactory {
    private static final String OAUTH_PATH = "/csp/gateway/am/api/auth/api-tokens/authorize";
    private static final String TYPE = "CSP API TOKEN";
    private final String cspBaseURL;
    private final byte[] postData;
    private int connectTimeoutMillis = 30000;
    private int readTimeoutMillis = 10000;

    public CSPUserTokenURLConnectionFactory(String cspBaseURL, String apiToken) {
        this.cspBaseURL = cspBaseURL;
        this.postData = ("grant_type=api_token&refresh_token=" + apiToken).getBytes(StandardCharsets.UTF_8);
    }

    public CSPUserTokenURLConnectionFactory(String cspBaseURL, String apiToken, int connectTimeoutMillis, int readTimeoutMillis) {
        this(cspBaseURL, apiToken);
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    public HttpURLConnection build() throws IOException {
        URL url = new URL(this.cspBaseURL + OAUTH_PATH);
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setConnectTimeout(this.connectTimeoutMillis);
        urlConn.setReadTimeout(this.readTimeoutMillis);
        urlConn.setRequestMethod("POST");
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setRequestProperty("Accept", "application/json");
        urlConn.setRequestProperty("Content-Length", Integer.toString(this.postData.length));
        return urlConn;
    }

    @Override
    public byte[] getPostData() {
        return this.postData;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

