/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.contract.v1;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.bcos.channel.client.TransactionSucCallback;
import org.bcos.web3j.abi.EventEncoder;
import org.bcos.web3j.abi.EventValues;
import org.bcos.web3j.abi.FunctionEncoder;
import org.bcos.web3j.abi.TypeReference;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.DynamicArray;
import org.bcos.web3j.abi.datatypes.DynamicBytes;
import org.bcos.web3j.abi.datatypes.Event;
import org.bcos.web3j.abi.datatypes.Function;
import org.bcos.web3j.abi.datatypes.StaticArray;
import org.bcos.web3j.abi.datatypes.Type;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Int256;
import org.bcos.web3j.abi.datatypes.generated.Uint256;
import org.bcos.web3j.abi.datatypes.generated.Uint8;
import org.bcos.web3j.crypto.Credentials;
import org.bcos.web3j.protocol.Web3j;
import org.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.bcos.web3j.protocol.core.methods.request.EthFilter;
import org.bcos.web3j.protocol.core.methods.response.Log;
import org.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.bcos.web3j.tx.Contract;
import org.bcos.web3j.tx.TransactionManager;
import rx.Observable;
import rx.functions.Func1;

public final class CptController
extends Contract {
    private static String BINARY = "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";
    public static final String ABI = "[{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"getCptDynamicBytes32Array\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes32[]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"getCredentialTemplateBlock\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"},{\"name\":\"publisher\",\"type\":\"address\"},{\"name\":\"intArray\",\"type\":\"int256[8]\"},{\"name\":\"bytes32Array\",\"type\":\"bytes32[8]\"},{\"name\":\"jsonSchemaArray\",\"type\":\"bytes32[128]\"},{\"name\":\"v\",\"type\":\"uint8\"},{\"name\":\"r\",\"type\":\"bytes32\"},{\"name\":\"s\",\"type\":\"bytes32\"}],\"name\":\"updateCpt\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"queryCpt\",\"outputs\":[{\"name\":\"publisher\",\"type\":\"address\"},{\"name\":\"intArray\",\"type\":\"int256[]\"},{\"name\":\"bytes32Array\",\"type\":\"bytes32[]\"},{\"name\":\"jsonSchemaArray\",\"type\":\"bytes32[]\"},{\"name\":\"v\",\"type\":\"uint8\"},{\"name\":\"r\",\"type\":\"bytes32\"},{\"name\":\"s\",\"type\":\"bytes32\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"getCptDynamicIntArray\",\"outputs\":[{\"name\":\"\",\"type\":\"int256[]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"},{\"name\":\"publisher\",\"type\":\"address\"},{\"name\":\"intArray\",\"type\":\"int256[8]\"},{\"name\":\"bytes32Array\",\"type\":\"bytes32[8]\"},{\"name\":\"jsonSchemaArray\",\"type\":\"bytes32[128]\"},{\"name\":\"v\",\"type\":\"uint8\"},{\"name\":\"r\",\"type\":\"bytes32\"},{\"name\":\"s\",\"type\":\"bytes32\"}],\"name\":\"registerCpt\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"roleControllerAddress\",\"type\":\"address\"}],\"name\":\"setRoleController\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"publisher\",\"type\":\"address\"},{\"name\":\"intArray\",\"type\":\"int256[8]\"},{\"name\":\"bytes32Array\",\"type\":\"bytes32[8]\"},{\"name\":\"jsonSchemaArray\",\"type\":\"bytes32[128]\"},{\"name\":\"v\",\"type\":\"uint8\"},{\"name\":\"r\",\"type\":\"bytes32\"},{\"name\":\"s\",\"type\":\"bytes32\"}],\"name\":\"registerCpt\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"getCptDynamicJsonSchemaArray\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes32[]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"},{\"name\":\"credentialPublicKey\",\"type\":\"bytes\"},{\"name\":\"credentialProof\",\"type\":\"bytes\"}],\"name\":\"putCredentialTemplate\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"inputs\":[{\"name\":\"cptDataAddress\",\"type\":\"address\"},{\"name\":\"weIdContractAddress\",\"type\":\"address\"}],\"payable\":false,\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"retCode\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"cptId\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"cptVersion\",\"type\":\"int256\"}],\"name\":\"RegisterCptRetLog\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"retCode\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"cptId\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"cptVersion\",\"type\":\"int256\"}],\"name\":\"UpdateCptRetLog\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"cptId\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"credentialPublicKey\",\"type\":\"bytes\"},{\"indexed\":false,\"name\":\"credentialProof\",\"type\":\"bytes\"}],\"name\":\"CredentialTemplate\",\"type\":\"event\"}]";

    private CptController(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, Boolean isInitByName) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit, isInitByName.booleanValue());
    }

    private CptController(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, Boolean isInitByName) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit, isInitByName);
    }

    private CptController(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit, false);
    }

    private CptController(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit, Boolean.valueOf(false));
    }

    public static List<RegisterCptRetLogEventResponse> getRegisterCptRetLogEvents(TransactionReceipt transactionReceipt) {
        Event event = new Event("RegisterCptRetLog", Arrays.asList(new TypeReference[0]), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
        List valueList = CptController.extractEventParameters((Event)event, (TransactionReceipt)transactionReceipt);
        ArrayList<RegisterCptRetLogEventResponse> responses = new ArrayList<RegisterCptRetLogEventResponse>(valueList.size());
        for (EventValues eventValues : valueList) {
            RegisterCptRetLogEventResponse typedResponse = new RegisterCptRetLogEventResponse();
            typedResponse.retCode = (Uint256)eventValues.getNonIndexedValues().get(0);
            typedResponse.cptId = (Uint256)eventValues.getNonIndexedValues().get(1);
            typedResponse.cptVersion = (Int256)eventValues.getNonIndexedValues().get(2);
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<RegisterCptRetLogEventResponse> registerCptRetLogEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        final Event event = new Event("RegisterCptRetLog", Arrays.asList(new TypeReference[0]), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)event));
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, RegisterCptRetLogEventResponse>(){

            public RegisterCptRetLogEventResponse call(Log log) {
                EventValues eventValues = CptController.extractEventParameters((Event)event, (Log)log);
                RegisterCptRetLogEventResponse typedResponse = new RegisterCptRetLogEventResponse();
                typedResponse.retCode = (Uint256)eventValues.getNonIndexedValues().get(0);
                typedResponse.cptId = (Uint256)eventValues.getNonIndexedValues().get(1);
                typedResponse.cptVersion = (Int256)eventValues.getNonIndexedValues().get(2);
                return typedResponse;
            }
        });
    }

    public static List<UpdateCptRetLogEventResponse> getUpdateCptRetLogEvents(TransactionReceipt transactionReceipt) {
        Event event = new Event("UpdateCptRetLog", Arrays.asList(new TypeReference[0]), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
        List valueList = CptController.extractEventParameters((Event)event, (TransactionReceipt)transactionReceipt);
        ArrayList<UpdateCptRetLogEventResponse> responses = new ArrayList<UpdateCptRetLogEventResponse>(valueList.size());
        for (EventValues eventValues : valueList) {
            UpdateCptRetLogEventResponse typedResponse = new UpdateCptRetLogEventResponse();
            typedResponse.retCode = (Uint256)eventValues.getNonIndexedValues().get(0);
            typedResponse.cptId = (Uint256)eventValues.getNonIndexedValues().get(1);
            typedResponse.cptVersion = (Int256)eventValues.getNonIndexedValues().get(2);
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<UpdateCptRetLogEventResponse> updateCptRetLogEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        final Event event = new Event("UpdateCptRetLog", Arrays.asList(new TypeReference[0]), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)event));
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, UpdateCptRetLogEventResponse>(){

            public UpdateCptRetLogEventResponse call(Log log) {
                EventValues eventValues = CptController.extractEventParameters((Event)event, (Log)log);
                UpdateCptRetLogEventResponse typedResponse = new UpdateCptRetLogEventResponse();
                typedResponse.retCode = (Uint256)eventValues.getNonIndexedValues().get(0);
                typedResponse.cptId = (Uint256)eventValues.getNonIndexedValues().get(1);
                typedResponse.cptVersion = (Int256)eventValues.getNonIndexedValues().get(2);
                return typedResponse;
            }
        });
    }

    public static List<CredentialTemplateEventResponse> getCredentialTemplateEvents(TransactionReceipt transactionReceipt) {
        Event event = new Event("CredentialTemplate", Arrays.asList(new TypeReference[0]), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<DynamicBytes>(){}, new TypeReference<DynamicBytes>(){}));
        List valueList = CptController.extractEventParameters((Event)event, (TransactionReceipt)transactionReceipt);
        ArrayList<CredentialTemplateEventResponse> responses = new ArrayList<CredentialTemplateEventResponse>(valueList.size());
        for (EventValues eventValues : valueList) {
            CredentialTemplateEventResponse typedResponse = new CredentialTemplateEventResponse();
            typedResponse.cptId = (Uint256)eventValues.getNonIndexedValues().get(0);
            typedResponse.credentialPublicKey = (DynamicBytes)eventValues.getNonIndexedValues().get(1);
            typedResponse.credentialProof = (DynamicBytes)eventValues.getNonIndexedValues().get(2);
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<CredentialTemplateEventResponse> credentialTemplateEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        final Event event = new Event("CredentialTemplate", Arrays.asList(new TypeReference[0]), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<DynamicBytes>(){}, new TypeReference<DynamicBytes>(){}));
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)event));
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, CredentialTemplateEventResponse>(){

            public CredentialTemplateEventResponse call(Log log) {
                EventValues eventValues = CptController.extractEventParameters((Event)event, (Log)log);
                CredentialTemplateEventResponse typedResponse = new CredentialTemplateEventResponse();
                typedResponse.cptId = (Uint256)eventValues.getNonIndexedValues().get(0);
                typedResponse.credentialPublicKey = (DynamicBytes)eventValues.getNonIndexedValues().get(1);
                typedResponse.credentialProof = (DynamicBytes)eventValues.getNonIndexedValues().get(2);
                return typedResponse;
            }
        });
    }

    public Future<DynamicArray<Bytes32>> getCptDynamicBytes32Array(Uint256 cptId) {
        Function function = new Function("getCptDynamicBytes32Array", Arrays.asList(cptId), Arrays.asList(new TypeReference<DynamicArray<Bytes32>>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<Uint256> getCredentialTemplateBlock(Uint256 cptId) {
        Function function = new Function("getCredentialTemplateBlock", Arrays.asList(cptId), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<TransactionReceipt> updateCpt(Uint256 cptId, Address publisher, StaticArray<Int256> intArray, StaticArray<Bytes32> bytes32Array, StaticArray<Bytes32> jsonSchemaArray, Uint8 v, Bytes32 r, Bytes32 s) {
        Function function = new Function("updateCpt", Arrays.asList(cptId, publisher, intArray, bytes32Array, jsonSchemaArray, v, r, s), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void updateCpt(Uint256 cptId, Address publisher, StaticArray<Int256> intArray, StaticArray<Bytes32> bytes32Array, StaticArray<Bytes32> jsonSchemaArray, Uint8 v, Bytes32 r, Bytes32 s, TransactionSucCallback callback) {
        Function function = new Function("updateCpt", Arrays.asList(cptId, publisher, intArray, bytes32Array, jsonSchemaArray, v, r, s), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public Future<List<Type>> queryCpt(Uint256 cptId) {
        Function function = new Function("queryCpt", Arrays.asList(cptId), Arrays.asList(new TypeReference<Address>(){}, new TypeReference<DynamicArray<Int256>>(){}, new TypeReference<DynamicArray<Bytes32>>(){}, new TypeReference<DynamicArray<Bytes32>>(){}, new TypeReference<Uint8>(){}, new TypeReference<Bytes32>(){}, new TypeReference<Bytes32>(){}));
        return this.executeCallMultipleValueReturnAsync(function);
    }

    public Future<DynamicArray<Int256>> getCptDynamicIntArray(Uint256 cptId) {
        Function function = new Function("getCptDynamicIntArray", Arrays.asList(cptId), Arrays.asList(new TypeReference<DynamicArray<Int256>>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<TransactionReceipt> registerCpt(Uint256 cptId, Address publisher, StaticArray<Int256> intArray, StaticArray<Bytes32> bytes32Array, StaticArray<Bytes32> jsonSchemaArray, Uint8 v, Bytes32 r, Bytes32 s) {
        Function function = new Function("registerCpt", Arrays.asList(cptId, publisher, intArray, bytes32Array, jsonSchemaArray, v, r, s), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void registerCpt(Uint256 cptId, Address publisher, StaticArray<Int256> intArray, StaticArray<Bytes32> bytes32Array, StaticArray<Bytes32> jsonSchemaArray, Uint8 v, Bytes32 r, Bytes32 s, TransactionSucCallback callback) {
        Function function = new Function("registerCpt", Arrays.asList(cptId, publisher, intArray, bytes32Array, jsonSchemaArray, v, r, s), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public Future<TransactionReceipt> setRoleController(Address roleControllerAddress) {
        Function function = new Function("setRoleController", Arrays.asList(roleControllerAddress), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void setRoleController(Address roleControllerAddress, TransactionSucCallback callback) {
        Function function = new Function("setRoleController", Arrays.asList(roleControllerAddress), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public Future<TransactionReceipt> registerCpt(Address publisher, StaticArray<Int256> intArray, StaticArray<Bytes32> bytes32Array, StaticArray<Bytes32> jsonSchemaArray, Uint8 v, Bytes32 r, Bytes32 s) {
        Function function = new Function("registerCpt", Arrays.asList(publisher, intArray, bytes32Array, jsonSchemaArray, v, r, s), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void registerCpt(Address publisher, StaticArray<Int256> intArray, StaticArray<Bytes32> bytes32Array, StaticArray<Bytes32> jsonSchemaArray, Uint8 v, Bytes32 r, Bytes32 s, TransactionSucCallback callback) {
        Function function = new Function("registerCpt", Arrays.asList(publisher, intArray, bytes32Array, jsonSchemaArray, v, r, s), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public Future<DynamicArray<Bytes32>> getCptDynamicJsonSchemaArray(Uint256 cptId) {
        Function function = new Function("getCptDynamicJsonSchemaArray", Arrays.asList(cptId), Arrays.asList(new TypeReference<DynamicArray<Bytes32>>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<TransactionReceipt> putCredentialTemplate(Uint256 cptId, DynamicBytes credentialPublicKey, DynamicBytes credentialProof) {
        Function function = new Function("putCredentialTemplate", Arrays.asList(cptId, credentialPublicKey, credentialProof), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void putCredentialTemplate(Uint256 cptId, DynamicBytes credentialPublicKey, DynamicBytes credentialProof, TransactionSucCallback callback) {
        Function function = new Function("putCredentialTemplate", Arrays.asList(cptId, credentialPublicKey, credentialProof), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public static Future<CptController> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue, Address cptDataAddress, Address weIdContractAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(cptDataAddress, weIdContractAddress));
        return CptController.deployAsync(CptController.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor, (BigInteger)initialWeiValue);
    }

    public static Future<CptController> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue, Address cptDataAddress, Address weIdContractAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(cptDataAddress, weIdContractAddress));
        return CptController.deployAsync(CptController.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor, (BigInteger)initialWeiValue);
    }

    public static CptController load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new CptController(contractAddress, web3j, credentials, gasPrice, gasLimit, (Boolean)false);
    }

    public static CptController load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new CptController(contractAddress, web3j, transactionManager, gasPrice, gasLimit, (Boolean)false);
    }

    public static CptController loadByName(String contractName, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new CptController(contractName, web3j, credentials, gasPrice, gasLimit, (Boolean)true);
    }

    public static CptController loadByName(String contractName, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new CptController(contractName, web3j, transactionManager, gasPrice, gasLimit, (Boolean)true);
    }

    public static class CredentialTemplateEventResponse {
        public Uint256 cptId;
        public DynamicBytes credentialPublicKey;
        public DynamicBytes credentialProof;
    }

    public static class UpdateCptRetLogEventResponse {
        public Uint256 retCode;
        public Uint256 cptId;
        public Int256 cptVersion;
    }

    public static class RegisterCptRetLogEventResponse {
        public Uint256 retCode;
        public Uint256 cptId;
        public Int256 cptVersion;
    }
}

