/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.contract.v1;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Future;
import org.bcos.channel.client.TransactionSucCallback;
import org.bcos.web3j.abi.TypeReference;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.Bool;
import org.bcos.web3j.abi.datatypes.Function;
import org.bcos.web3j.abi.datatypes.StaticArray;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Uint256;
import org.bcos.web3j.crypto.Credentials;
import org.bcos.web3j.protocol.Web3j;
import org.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.bcos.web3j.tx.Contract;
import org.bcos.web3j.tx.TransactionManager;

public final class SpecificIssuerData
extends Contract {
    private static String BINARY = "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";
    public static final String ABI = "[{\"constant\":false,\"inputs\":[{\"name\":\"typeName\",\"type\":\"bytes32\"},{\"name\":\"addr\",\"type\":\"address\"}],\"name\":\"addIssuer\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"typeName\",\"type\":\"bytes32\"},{\"name\":\"addr\",\"type\":\"address\"}],\"name\":\"isSpecificTypeIssuer\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"typeName\",\"type\":\"bytes32\"},{\"name\":\"extraValue\",\"type\":\"bytes32\"}],\"name\":\"addExtraValue\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"typeName\",\"type\":\"bytes32\"}],\"name\":\"registerIssuerType\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"typeName\",\"type\":\"bytes32\"},{\"name\":\"startPos\",\"type\":\"uint256\"}],\"name\":\"getSpecificTypeIssuers\",\"outputs\":[{\"name\":\"\",\"type\":\"address[50]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"typeName\",\"type\":\"bytes32\"}],\"name\":\"getSpecificTypeIssuerLength\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"typeName\",\"type\":\"bytes32\"}],\"name\":\"getExtraValue\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes32[8]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"name\",\"type\":\"bytes32\"}],\"name\":\"isIssuerTypeExist\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"typeName\",\"type\":\"bytes32\"},{\"name\":\"addr\",\"type\":\"address\"}],\"name\":\"removeIssuer\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"}]";

    private SpecificIssuerData(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, Boolean isInitByName) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit, isInitByName.booleanValue());
    }

    private SpecificIssuerData(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, Boolean isInitByName) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit, isInitByName);
    }

    private SpecificIssuerData(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit, false);
    }

    private SpecificIssuerData(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit, Boolean.valueOf(false));
    }

    public Future<TransactionReceipt> addIssuer(Bytes32 typeName, Address addr) {
        Function function = new Function("addIssuer", Arrays.asList(typeName, addr), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void addIssuer(Bytes32 typeName, Address addr, TransactionSucCallback callback) {
        Function function = new Function("addIssuer", Arrays.asList(typeName, addr), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public Future<Bool> isSpecificTypeIssuer(Bytes32 typeName, Address addr) {
        Function function = new Function("isSpecificTypeIssuer", Arrays.asList(typeName, addr), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<TransactionReceipt> addExtraValue(Bytes32 typeName, Bytes32 extraValue) {
        Function function = new Function("addExtraValue", Arrays.asList(typeName, extraValue), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void addExtraValue(Bytes32 typeName, Bytes32 extraValue, TransactionSucCallback callback) {
        Function function = new Function("addExtraValue", Arrays.asList(typeName, extraValue), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public Future<TransactionReceipt> registerIssuerType(Bytes32 typeName) {
        Function function = new Function("registerIssuerType", Arrays.asList(typeName), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void registerIssuerType(Bytes32 typeName, TransactionSucCallback callback) {
        Function function = new Function("registerIssuerType", Arrays.asList(typeName), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public Future<StaticArray<Address>> getSpecificTypeIssuers(Bytes32 typeName, Uint256 startPos) {
        Function function = new Function("getSpecificTypeIssuers", Arrays.asList(typeName, startPos), Arrays.asList(new TypeReference<StaticArray<Address>>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<Uint256> getSpecificTypeIssuerLength(Bytes32 typeName) {
        Function function = new Function("getSpecificTypeIssuerLength", Arrays.asList(typeName), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<StaticArray<Bytes32>> getExtraValue(Bytes32 typeName) {
        Function function = new Function("getExtraValue", Arrays.asList(typeName), Arrays.asList(new TypeReference<StaticArray<Bytes32>>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<Bool> isIssuerTypeExist(Bytes32 name) {
        Function function = new Function("isIssuerTypeExist", Arrays.asList(name), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<TransactionReceipt> removeIssuer(Bytes32 typeName, Address addr) {
        Function function = new Function("removeIssuer", Arrays.asList(typeName, addr), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void removeIssuer(Bytes32 typeName, Address addr, TransactionSucCallback callback) {
        Function function = new Function("removeIssuer", Arrays.asList(typeName, addr), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public static Future<SpecificIssuerData> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue) {
        return SpecificIssuerData.deployAsync(SpecificIssuerData.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"", (BigInteger)initialWeiValue);
    }

    public static Future<SpecificIssuerData> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue) {
        return SpecificIssuerData.deployAsync(SpecificIssuerData.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"", (BigInteger)initialWeiValue);
    }

    public static SpecificIssuerData load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new SpecificIssuerData(contractAddress, web3j, credentials, gasPrice, gasLimit, (Boolean)false);
    }

    public static SpecificIssuerData load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new SpecificIssuerData(contractAddress, web3j, transactionManager, gasPrice, gasLimit, (Boolean)false);
    }

    public static SpecificIssuerData loadByName(String contractName, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new SpecificIssuerData(contractName, web3j, credentials, gasPrice, gasLimit, (Boolean)true);
    }

    public static SpecificIssuerData loadByName(String contractName, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new SpecificIssuerData(contractName, web3j, transactionManager, gasPrice, gasLimit, (Boolean)true);
    }
}

