/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.contract.v1;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.bcos.channel.client.TransactionSucCallback;
import org.bcos.web3j.abi.EventEncoder;
import org.bcos.web3j.abi.EventValues;
import org.bcos.web3j.abi.TypeReference;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.Bool;
import org.bcos.web3j.abi.datatypes.DynamicBytes;
import org.bcos.web3j.abi.datatypes.Event;
import org.bcos.web3j.abi.datatypes.Function;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Int256;
import org.bcos.web3j.abi.datatypes.generated.Uint256;
import org.bcos.web3j.crypto.Credentials;
import org.bcos.web3j.protocol.Web3j;
import org.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.bcos.web3j.protocol.core.methods.request.EthFilter;
import org.bcos.web3j.protocol.core.methods.response.Log;
import org.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.bcos.web3j.tx.Contract;
import org.bcos.web3j.tx.TransactionManager;
import rx.Observable;
import rx.functions.Func1;

public final class WeIdContract
extends Contract {
    private static String BINARY = "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";
    public static final String ABI = "[{\"constant\":true,\"inputs\":[{\"name\":\"identity\",\"type\":\"address\"}],\"name\":\"isIdentityExist\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"identity\",\"type\":\"address\"},{\"name\":\"key\",\"type\":\"bytes32\"},{\"name\":\"value\",\"type\":\"bytes\"},{\"name\":\"updated\",\"type\":\"int256\"}],\"name\":\"setAttribute\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"identity\",\"type\":\"address\"}],\"name\":\"getLatestRelatedBlock\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"identity\",\"type\":\"address\"},{\"name\":\"auth\",\"type\":\"bytes\"},{\"name\":\"created\",\"type\":\"bytes\"},{\"name\":\"updated\",\"type\":\"int256\"}],\"name\":\"createWeId\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"identity\",\"type\":\"address\"},{\"indexed\":false,\"name\":\"key\",\"type\":\"bytes32\"},{\"indexed\":false,\"name\":\"value\",\"type\":\"bytes\"},{\"indexed\":false,\"name\":\"previousBlock\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"updated\",\"type\":\"int256\"}],\"name\":\"WeIdAttributeChanged\",\"type\":\"event\"}]";

    private WeIdContract(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, Boolean isInitByName) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit, isInitByName.booleanValue());
    }

    private WeIdContract(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, Boolean isInitByName) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit, isInitByName);
    }

    private WeIdContract(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit, false);
    }

    private WeIdContract(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit, Boolean.valueOf(false));
    }

    public static List<WeIdAttributeChangedEventResponse> getWeIdAttributeChangedEvents(TransactionReceipt transactionReceipt) {
        Event event = new Event("WeIdAttributeChanged", Arrays.asList(new TypeReference<Address>(){}), Arrays.asList(new TypeReference<Bytes32>(){}, new TypeReference<DynamicBytes>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
        List valueList = WeIdContract.extractEventParameters((Event)event, (TransactionReceipt)transactionReceipt);
        ArrayList<WeIdAttributeChangedEventResponse> responses = new ArrayList<WeIdAttributeChangedEventResponse>(valueList.size());
        for (EventValues eventValues : valueList) {
            WeIdAttributeChangedEventResponse typedResponse = new WeIdAttributeChangedEventResponse();
            typedResponse.identity = (Address)eventValues.getIndexedValues().get(0);
            typedResponse.key = (Bytes32)eventValues.getNonIndexedValues().get(0);
            typedResponse.value = (DynamicBytes)eventValues.getNonIndexedValues().get(1);
            typedResponse.previousBlock = (Uint256)eventValues.getNonIndexedValues().get(2);
            typedResponse.updated = (Int256)eventValues.getNonIndexedValues().get(3);
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<WeIdAttributeChangedEventResponse> weIdAttributeChangedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        final Event event = new Event("WeIdAttributeChanged", Arrays.asList(new TypeReference<Address>(){}), Arrays.asList(new TypeReference<Bytes32>(){}, new TypeReference<DynamicBytes>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)event));
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, WeIdAttributeChangedEventResponse>(){

            public WeIdAttributeChangedEventResponse call(Log log) {
                EventValues eventValues = WeIdContract.extractEventParameters((Event)event, (Log)log);
                WeIdAttributeChangedEventResponse typedResponse = new WeIdAttributeChangedEventResponse();
                typedResponse.identity = (Address)eventValues.getIndexedValues().get(0);
                typedResponse.key = (Bytes32)eventValues.getNonIndexedValues().get(0);
                typedResponse.value = (DynamicBytes)eventValues.getNonIndexedValues().get(1);
                typedResponse.previousBlock = (Uint256)eventValues.getNonIndexedValues().get(2);
                typedResponse.updated = (Int256)eventValues.getNonIndexedValues().get(3);
                return typedResponse;
            }
        });
    }

    public Future<Bool> isIdentityExist(Address identity) {
        Function function = new Function("isIdentityExist", Arrays.asList(identity), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<TransactionReceipt> setAttribute(Address identity, Bytes32 key, DynamicBytes value, Int256 updated) {
        Function function = new Function("setAttribute", Arrays.asList(identity, key, value, updated), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void setAttribute(Address identity, Bytes32 key, DynamicBytes value, Int256 updated, TransactionSucCallback callback) {
        Function function = new Function("setAttribute", Arrays.asList(identity, key, value, updated), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public Future<Uint256> getLatestRelatedBlock(Address identity) {
        Function function = new Function("getLatestRelatedBlock", Arrays.asList(identity), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeCallSingleValueReturnAsync(function);
    }

    public Future<TransactionReceipt> createWeId(Address identity, DynamicBytes auth, DynamicBytes created, Int256 updated) {
        Function function = new Function("createWeId", Arrays.asList(identity, auth, created, updated), Collections.emptyList());
        return this.executeTransactionAsync(function);
    }

    public void createWeId(Address identity, DynamicBytes auth, DynamicBytes created, Int256 updated, TransactionSucCallback callback) {
        Function function = new Function("createWeId", Arrays.asList(identity, auth, created, updated), Collections.emptyList());
        this.executeTransactionAsync(function, callback);
    }

    public static Future<WeIdContract> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue) {
        return WeIdContract.deployAsync(WeIdContract.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"", (BigInteger)initialWeiValue);
    }

    public static Future<WeIdContract> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue) {
        return WeIdContract.deployAsync(WeIdContract.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"", (BigInteger)initialWeiValue);
    }

    public static WeIdContract load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new WeIdContract(contractAddress, web3j, credentials, gasPrice, gasLimit, (Boolean)false);
    }

    public static WeIdContract load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new WeIdContract(contractAddress, web3j, transactionManager, gasPrice, gasLimit, (Boolean)false);
    }

    public static WeIdContract loadByName(String contractName, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new WeIdContract(contractName, web3j, credentials, gasPrice, gasLimit, (Boolean)true);
    }

    public static WeIdContract loadByName(String contractName, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new WeIdContract(contractName, web3j, transactionManager, gasPrice, gasLimit, (Boolean)true);
    }

    public static class WeIdAttributeChangedEventResponse {
        public Address identity;
        public Bytes32 key;
        public DynamicBytes value;
        public Uint256 previousBlock;
        public Int256 updated;
    }
}

