/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.contract.v2;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.web3j.abi.EventEncoder;
import org.fisco.bcos.web3j.abi.FunctionEncoder;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.Utils;
import org.fisco.bcos.web3j.abi.datatypes.Address;
import org.fisco.bcos.web3j.abi.datatypes.DynamicArray;
import org.fisco.bcos.web3j.abi.datatypes.DynamicBytes;
import org.fisco.bcos.web3j.abi.datatypes.Event;
import org.fisco.bcos.web3j.abi.datatypes.Type;
import org.fisco.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.fisco.bcos.web3j.abi.datatypes.generated.Int256;
import org.fisco.bcos.web3j.abi.datatypes.generated.StaticArray128;
import org.fisco.bcos.web3j.abi.datatypes.generated.StaticArray8;
import org.fisco.bcos.web3j.abi.datatypes.generated.Uint256;
import org.fisco.bcos.web3j.abi.datatypes.generated.Uint8;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.fisco.bcos.web3j.protocol.core.RemoteCall;
import org.fisco.bcos.web3j.protocol.core.methods.request.BcosFilter;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tuples.generated.Tuple7;
import org.fisco.bcos.web3j.tx.Contract;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;

public class CptController
extends Contract {
    public static final String BINARY = "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";
    public static final String ABI = "[{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"getCptDynamicBytes32Array\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes32[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"getCredentialTemplateBlock\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"},{\"name\":\"publisher\",\"type\":\"address\"},{\"name\":\"intArray\",\"type\":\"int256[8]\"},{\"name\":\"bytes32Array\",\"type\":\"bytes32[8]\"},{\"name\":\"jsonSchemaArray\",\"type\":\"bytes32[128]\"},{\"name\":\"v\",\"type\":\"uint8\"},{\"name\":\"r\",\"type\":\"bytes32\"},{\"name\":\"s\",\"type\":\"bytes32\"}],\"name\":\"updateCpt\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"queryCpt\",\"outputs\":[{\"name\":\"publisher\",\"type\":\"address\"},{\"name\":\"intArray\",\"type\":\"int256[]\"},{\"name\":\"bytes32Array\",\"type\":\"bytes32[]\"},{\"name\":\"jsonSchemaArray\",\"type\":\"bytes32[]\"},{\"name\":\"v\",\"type\":\"uint8\"},{\"name\":\"r\",\"type\":\"bytes32\"},{\"name\":\"s\",\"type\":\"bytes32\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"getCptDynamicIntArray\",\"outputs\":[{\"name\":\"\",\"type\":\"int256[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"},{\"name\":\"publisher\",\"type\":\"address\"},{\"name\":\"intArray\",\"type\":\"int256[8]\"},{\"name\":\"bytes32Array\",\"type\":\"bytes32[8]\"},{\"name\":\"jsonSchemaArray\",\"type\":\"bytes32[128]\"},{\"name\":\"v\",\"type\":\"uint8\"},{\"name\":\"r\",\"type\":\"bytes32\"},{\"name\":\"s\",\"type\":\"bytes32\"}],\"name\":\"registerCpt\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"roleControllerAddress\",\"type\":\"address\"}],\"name\":\"setRoleController\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"publisher\",\"type\":\"address\"},{\"name\":\"intArray\",\"type\":\"int256[8]\"},{\"name\":\"bytes32Array\",\"type\":\"bytes32[8]\"},{\"name\":\"jsonSchemaArray\",\"type\":\"bytes32[128]\"},{\"name\":\"v\",\"type\":\"uint8\"},{\"name\":\"r\",\"type\":\"bytes32\"},{\"name\":\"s\",\"type\":\"bytes32\"}],\"name\":\"registerCpt\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"}],\"name\":\"getCptDynamicJsonSchemaArray\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes32[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"cptId\",\"type\":\"uint256\"},{\"name\":\"credentialPublicKey\",\"type\":\"bytes\"},{\"name\":\"credentialProof\",\"type\":\"bytes\"}],\"name\":\"putCredentialTemplate\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"name\":\"cptDataAddress\",\"type\":\"address\"},{\"name\":\"weIdContractAddress\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"retCode\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"cptId\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"cptVersion\",\"type\":\"int256\"}],\"name\":\"RegisterCptRetLog\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"retCode\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"cptId\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"cptVersion\",\"type\":\"int256\"}],\"name\":\"UpdateCptRetLog\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"cptId\",\"type\":\"uint256\"},{\"indexed\":false,\"name\":\"credentialPublicKey\",\"type\":\"bytes\"},{\"indexed\":false,\"name\":\"credentialProof\",\"type\":\"bytes\"}],\"name\":\"CredentialTemplate\",\"type\":\"event\"}]";
    public static final String FUNC_GETCPTDYNAMICBYTES32ARRAY = "getCptDynamicBytes32Array";
    public static final String FUNC_GETCREDENTIALTEMPLATEBLOCK = "getCredentialTemplateBlock";
    public static final String FUNC_UPDATECPT = "updateCpt";
    public static final String FUNC_QUERYCPT = "queryCpt";
    public static final String FUNC_GETCPTDYNAMICINTARRAY = "getCptDynamicIntArray";
    public static final String FUNC_REGISTERCPT = "registerCpt";
    public static final String FUNC_SETROLECONTROLLER = "setRoleController";
    public static final String FUNC_GETCPTDYNAMICJSONSCHEMAARRAY = "getCptDynamicJsonSchemaArray";
    public static final String FUNC_PUTCREDENTIALTEMPLATE = "putCredentialTemplate";
    public static final Event REGISTERCPTRETLOG_EVENT = new Event("RegisterCptRetLog", Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
    public static final Event UPDATECPTRETLOG_EVENT = new Event("UpdateCptRetLog", Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
    public static final Event CREDENTIALTEMPLATE_EVENT = new Event("CredentialTemplate", Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<DynamicBytes>(){}, new TypeReference<DynamicBytes>(){}));

    @Deprecated
    protected CptController(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected CptController(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected CptController(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected CptController(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<List> getCptDynamicBytes32Array(BigInteger cptId) {
        final org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_GETCPTDYNAMICBYTES32ARRAY, Arrays.asList(new Uint256(cptId)), Arrays.asList(new TypeReference<DynamicArray<Bytes32>>(){}));
        return new RemoteCall((Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = (List)CptController.this.executeCallSingleValueReturn(function, List.class);
                return CptController.convertToNative((List)result);
            }
        });
    }

    public RemoteCall<BigInteger> getCredentialTemplateBlock(BigInteger cptId) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_GETCREDENTIALTEMPLATEBLOCK, Arrays.asList(new Uint256(cptId)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> updateCpt(BigInteger cptId, String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_UPDATECPT, Arrays.asList(new Uint256(cptId), new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void updateCpt(BigInteger cptId, String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s, TransactionSucCallback callback) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_UPDATECPT, Arrays.asList(new Uint256(cptId), new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String updateCptSeq(BigInteger cptId, String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_UPDATECPT, Arrays.asList(new Uint256(cptId), new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public RemoteCall<Tuple7<String, List<BigInteger>, List<byte[]>, List<byte[]>, BigInteger, byte[], byte[]>> queryCpt(BigInteger cptId) {
        final org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_QUERYCPT, Arrays.asList(new Uint256(cptId)), Arrays.asList(new TypeReference<Address>(){}, new TypeReference<DynamicArray<Int256>>(){}, new TypeReference<DynamicArray<Bytes32>>(){}, new TypeReference<DynamicArray<Bytes32>>(){}, new TypeReference<Uint8>(){}, new TypeReference<Bytes32>(){}, new TypeReference<Bytes32>(){}));
        return new RemoteCall((Callable)new Callable<Tuple7<String, List<BigInteger>, List<byte[]>, List<byte[]>, BigInteger, byte[], byte[]>>(){

            @Override
            public Tuple7<String, List<BigInteger>, List<byte[]>, List<byte[]>, BigInteger, byte[], byte[]> call() throws Exception {
                List results = CptController.this.executeCallMultipleValueReturn(function);
                return new Tuple7((Object)((String)((Type)results.get(0)).getValue()), (Object)CptController.convertToNative((List)((List)((Type)results.get(1)).getValue())), (Object)CptController.convertToNative((List)((List)((Type)results.get(2)).getValue())), (Object)CptController.convertToNative((List)((List)((Type)results.get(3)).getValue())), (Object)((BigInteger)((Type)results.get(4)).getValue()), (Object)((byte[])((Type)results.get(5)).getValue()), (Object)((byte[])((Type)results.get(6)).getValue()));
            }
        });
    }

    public RemoteCall<List> getCptDynamicIntArray(BigInteger cptId) {
        final org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_GETCPTDYNAMICINTARRAY, Arrays.asList(new Uint256(cptId)), Arrays.asList(new TypeReference<DynamicArray<Int256>>(){}));
        return new RemoteCall((Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = (List)CptController.this.executeCallSingleValueReturn(function, List.class);
                return CptController.convertToNative((List)result);
            }
        });
    }

    public RemoteCall<TransactionReceipt> registerCpt(BigInteger cptId, String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_REGISTERCPT, Arrays.asList(new Uint256(cptId), new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void registerCpt(BigInteger cptId, String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s, TransactionSucCallback callback) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_REGISTERCPT, Arrays.asList(new Uint256(cptId), new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String registerCptSeq(BigInteger cptId, String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_REGISTERCPT, Arrays.asList(new Uint256(cptId), new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public RemoteCall<TransactionReceipt> setRoleController(String roleControllerAddress) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_SETROLECONTROLLER, Arrays.asList(new Address(roleControllerAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void setRoleController(String roleControllerAddress, TransactionSucCallback callback) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_SETROLECONTROLLER, Arrays.asList(new Address(roleControllerAddress)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String setRoleControllerSeq(String roleControllerAddress) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_SETROLECONTROLLER, Arrays.asList(new Address(roleControllerAddress)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public RemoteCall<TransactionReceipt> registerCpt(String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_REGISTERCPT, Arrays.asList(new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void registerCpt(String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s, TransactionSucCallback callback) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_REGISTERCPT, Arrays.asList(new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String registerCptSeq(String publisher, List<BigInteger> intArray, List<byte[]> bytes32Array, List<byte[]> jsonSchemaArray, BigInteger v, byte[] r, byte[] s) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_REGISTERCPT, Arrays.asList(new Address(publisher), new StaticArray8(Utils.typeMap(intArray, Int256.class)), new StaticArray8(Utils.typeMap(bytes32Array, Bytes32.class)), new StaticArray128(Utils.typeMap(jsonSchemaArray, Bytes32.class)), new Uint8(v), new Bytes32(r), new Bytes32(s)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public RemoteCall<List> getCptDynamicJsonSchemaArray(BigInteger cptId) {
        final org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_GETCPTDYNAMICJSONSCHEMAARRAY, Arrays.asList(new Uint256(cptId)), Arrays.asList(new TypeReference<DynamicArray<Bytes32>>(){}));
        return new RemoteCall((Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = (List)CptController.this.executeCallSingleValueReturn(function, List.class);
                return CptController.convertToNative((List)result);
            }
        });
    }

    public RemoteCall<TransactionReceipt> putCredentialTemplate(BigInteger cptId, byte[] credentialPublicKey, byte[] credentialProof) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_PUTCREDENTIALTEMPLATE, Arrays.asList(new Uint256(cptId), new DynamicBytes(credentialPublicKey), new DynamicBytes(credentialProof)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void putCredentialTemplate(BigInteger cptId, byte[] credentialPublicKey, byte[] credentialProof, TransactionSucCallback callback) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_PUTCREDENTIALTEMPLATE, Arrays.asList(new Uint256(cptId), new DynamicBytes(credentialPublicKey), new DynamicBytes(credentialProof)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String putCredentialTemplateSeq(BigInteger cptId, byte[] credentialPublicKey, byte[] credentialProof) {
        org.fisco.bcos.web3j.abi.datatypes.Function function = new org.fisco.bcos.web3j.abi.datatypes.Function(FUNC_PUTCREDENTIALTEMPLATE, Arrays.asList(new Uint256(cptId), new DynamicBytes(credentialPublicKey), new DynamicBytes(credentialProof)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public List<RegisterCptRetLogEventResponse> getRegisterCptRetLogEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(REGISTERCPTRETLOG_EVENT, transactionReceipt);
        ArrayList<RegisterCptRetLogEventResponse> responses = new ArrayList<RegisterCptRetLogEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RegisterCptRetLogEventResponse typedResponse = new RegisterCptRetLogEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.retCode = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.cptId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.cptVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<RegisterCptRetLogEventResponse> registerCptRetLogEventFlowable(BcosFilter filter) {
        return this.web3j.logFlowable(filter).map((Function)new Function<Log, RegisterCptRetLogEventResponse>(){

            public RegisterCptRetLogEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = CptController.this.extractEventParametersWithLog(REGISTERCPTRETLOG_EVENT, log);
                RegisterCptRetLogEventResponse typedResponse = new RegisterCptRetLogEventResponse();
                typedResponse.log = log;
                typedResponse.retCode = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.cptId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.cptVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<RegisterCptRetLogEventResponse> registerCptRetLogEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        BcosFilter filter = new BcosFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REGISTERCPTRETLOG_EVENT));
        return this.registerCptRetLogEventFlowable(filter);
    }

    public List<UpdateCptRetLogEventResponse> getUpdateCptRetLogEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPDATECPTRETLOG_EVENT, transactionReceipt);
        ArrayList<UpdateCptRetLogEventResponse> responses = new ArrayList<UpdateCptRetLogEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpdateCptRetLogEventResponse typedResponse = new UpdateCptRetLogEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.retCode = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.cptId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.cptVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpdateCptRetLogEventResponse> updateCptRetLogEventFlowable(BcosFilter filter) {
        return this.web3j.logFlowable(filter).map((Function)new Function<Log, UpdateCptRetLogEventResponse>(){

            public UpdateCptRetLogEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = CptController.this.extractEventParametersWithLog(UPDATECPTRETLOG_EVENT, log);
                UpdateCptRetLogEventResponse typedResponse = new UpdateCptRetLogEventResponse();
                typedResponse.log = log;
                typedResponse.retCode = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.cptId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.cptVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpdateCptRetLogEventResponse> updateCptRetLogEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        BcosFilter filter = new BcosFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPDATECPTRETLOG_EVENT));
        return this.updateCptRetLogEventFlowable(filter);
    }

    public List<CredentialTemplateEventResponse> getCredentialTemplateEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CREDENTIALTEMPLATE_EVENT, transactionReceipt);
        ArrayList<CredentialTemplateEventResponse> responses = new ArrayList<CredentialTemplateEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            CredentialTemplateEventResponse typedResponse = new CredentialTemplateEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.cptId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.credentialPublicKey = (byte[])((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.credentialProof = (byte[])((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<CredentialTemplateEventResponse> credentialTemplateEventFlowable(BcosFilter filter) {
        return this.web3j.logFlowable(filter).map((Function)new Function<Log, CredentialTemplateEventResponse>(){

            public CredentialTemplateEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = CptController.this.extractEventParametersWithLog(CREDENTIALTEMPLATE_EVENT, log);
                CredentialTemplateEventResponse typedResponse = new CredentialTemplateEventResponse();
                typedResponse.log = log;
                typedResponse.cptId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.credentialPublicKey = (byte[])((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.credentialProof = (byte[])((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<CredentialTemplateEventResponse> credentialTemplateEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        BcosFilter filter = new BcosFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CREDENTIALTEMPLATE_EVENT));
        return this.credentialTemplateEventFlowable(filter);
    }

    @Deprecated
    public static CptController load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new CptController(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static CptController load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new CptController(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static CptController load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new CptController(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static CptController load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new CptController(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<CptController> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String cptDataAddress, String weIdContractAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(cptDataAddress), new Address(weIdContractAddress)));
        return CptController.deployRemoteCall(CptController.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    public static RemoteCall<CptController> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String cptDataAddress, String weIdContractAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(cptDataAddress), new Address(weIdContractAddress)));
        return CptController.deployRemoteCall(CptController.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<CptController> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String cptDataAddress, String weIdContractAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(cptDataAddress), new Address(weIdContractAddress)));
        return CptController.deployRemoteCall(CptController.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<CptController> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String cptDataAddress, String weIdContractAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(cptDataAddress), new Address(weIdContractAddress)));
        return CptController.deployRemoteCall(CptController.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    public static class CredentialTemplateEventResponse {
        public Log log;
        public BigInteger cptId;
        public byte[] credentialPublicKey;
        public byte[] credentialProof;
    }

    public static class UpdateCptRetLogEventResponse {
        public Log log;
        public BigInteger retCode;
        public BigInteger cptId;
        public BigInteger cptVersion;
    }

    public static class RegisterCptRetLogEventResponse {
        public Log log;
        public BigInteger retCode;
        public BigInteger cptId;
        public BigInteger cptVersion;
    }
}

