/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.app;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.amop.CheckAmopMsgHealthArgs;
import com.webank.weid.protocol.response.AmopNotifyMsgResult;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.service.impl.AmopServiceImpl;
import com.webank.weid.service.impl.WeIdServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppCommand {
    private static final Logger logger = LoggerFactory.getLogger(AppCommand.class);

    public static void main(String[] args) {
        Integer result = 0;
        try {
            String command;
            if (args.length < 2) {
                System.err.println("Parameter illegal, please check your input.");
                System.exit(1);
            }
            if (!StringUtils.equals((CharSequence)(command = args[0]), (CharSequence)"--checkhealth") && !StringUtils.equals((CharSequence)command, (CharSequence)"--checkweid")) {
                logger.error("[AppCommand] input command :{} is illegal.", (Object)command);
                System.err.println("Parameter illegal, please check your input command.");
                System.exit(1);
            }
            switch (command) {
                case "--checkhealth": {
                    result = AppCommand.checkAmopHealth(args[1]);
                    return;
                }
                case "--checkweid": {
                    result = AppCommand.checkWeid(args[1]);
                    return;
                }
            }
            logger.error("[AppCommand]: the command -> {} is not supported .", (Object)command);
        }
        catch (Exception e) {
            logger.error("[AppCommand] execute command with exception.", (Throwable)e);
            System.exit(1);
        }
        System.exit(result);
    }

    private static Integer checkWeid(String weid) {
        WeIdServiceImpl weidService = new WeIdServiceImpl();
        ResponseData<Boolean> resp = weidService.isWeIdExist(weid);
        if (resp.getErrorCode().intValue() == ErrorCode.SUCCESS.getCode()) {
            logger.info("[checkWeid] weid --> {} exists on blockchain.", (Object)weid);
            System.out.println("[checkWeid] weid --> " + weid + "exists on blockchain.");
        } else {
            logger.error("[checkWeid] weid --> {} does not exist on blockchain. response is {}", (Object)weid, resp);
            System.out.println("[checkWeid] weid --> " + weid + " does not exist on blockchain.");
        }
        return resp.getErrorCode();
    }

    private static Integer checkAmopHealth(String toOrgId) {
        AmopServiceImpl amopService = new AmopServiceImpl();
        CheckAmopMsgHealthArgs checkAmopMsgHealthArgs = new CheckAmopMsgHealthArgs();
        checkAmopMsgHealthArgs.setMessage("hello");
        ResponseData<AmopNotifyMsgResult> resp = amopService.checkDirectRouteMsgHealth(toOrgId, checkAmopMsgHealthArgs);
        if (resp.getErrorCode().intValue() == ErrorCode.SUCCESS.getCode()) {
            logger.info("[checkAmopHealth] toOrgId --> {} check success.", (Object)toOrgId);
            System.out.println("[checkAmopHealth] send amop message to OrgId -->" + toOrgId + " with success.");
        } else {
            logger.error("[checkAmopHealth] toOrgId --> {} check failed, response is {}", (Object)toOrgId, resp);
            System.out.println("[checkAmopHealth] toOrgId -->" + toOrgId + " check failed. please check log.");
        }
        return resp.getErrorCode();
    }
}

