/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.constant;

import com.webank.weid.protocol.amop.CheckAmopMsgHealthArgs;
import com.webank.weid.protocol.amop.GetEncryptKeyArgs;
import com.webank.weid.protocol.amop.GetPolicyAndChallengeArgs;
import com.webank.weid.protocol.response.AmopNotifyMsgResult;
import com.webank.weid.protocol.response.AmopResponse;
import com.webank.weid.protocol.response.GetEncryptKeyResponse;
import com.webank.weid.protocol.response.GetPolicyAndChallengeResponse;
import com.webank.weid.rpc.callback.AmopCallback;
import com.webank.weid.service.impl.base.AmopCommonArgs;
import com.webank.weid.util.DataToolUtils;

public enum AmopMsgType {
    TYPE_ERROR(0),
    TYPE_CHECK_DIRECT_ROUTE_MSG_HEALTH(1),
    TYPE_TRANSPORTATION(2),
    GET_ENCRYPT_KEY(3),
    GET_POLICY_AND_CHALLENGE(4);

    private Integer value;

    private AmopMsgType(Integer index) {
        this.value = index;
    }

    public Integer getValue() {
        return this.value;
    }

    public String callOnPush(AmopCallback amopCallback, String messageId, String msgBodyStr) {
        String resultBodyStr = null;
        switch (this) {
            case TYPE_CHECK_DIRECT_ROUTE_MSG_HEALTH: {
                CheckAmopMsgHealthArgs args = DataToolUtils.deserialize(msgBodyStr, CheckAmopMsgHealthArgs.class);
                args.setMessageId(messageId);
                AmopNotifyMsgResult result = amopCallback.onPush(args);
                resultBodyStr = DataToolUtils.serialize(result);
                break;
            }
            case TYPE_TRANSPORTATION: {
                AmopCommonArgs args = DataToolUtils.deserialize(msgBodyStr, AmopCommonArgs.class);
                AmopResponse result = amopCallback.onPush(args);
                resultBodyStr = DataToolUtils.serialize(result);
                break;
            }
            case GET_ENCRYPT_KEY: {
                GetEncryptKeyArgs args = DataToolUtils.deserialize(msgBodyStr, GetEncryptKeyArgs.class);
                GetEncryptKeyResponse result = amopCallback.onPush(args);
                resultBodyStr = DataToolUtils.serialize(result);
                break;
            }
            case GET_POLICY_AND_CHALLENGE: {
                GetPolicyAndChallengeArgs args = DataToolUtils.deserialize(msgBodyStr, GetPolicyAndChallengeArgs.class);
                GetPolicyAndChallengeResponse result = amopCallback.onPush(args);
                resultBodyStr = DataToolUtils.serialize(result);
                break;
            }
        }
        return resultBodyStr;
    }
}

