/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.constant;

public enum ErrorCode {
    SUCCESS(0, "success"),
    CONTRACT_ERROR_NO_PERMISSION(500000, "contract error: no permission to perform this task"),
    CPT_NOT_EXISTS(500301, "cpt does not exist"),
    CPT_ID_AUTHORITY_ISSUER_EXCEED_MAX(500302, "cpt id generated for authority issuer exceeds limited max value"),
    CPT_PUBLISHER_NOT_EXIST(500303, "cpt publisher does not exist"),
    CPT_ALREADY_EXIST(500304, "cpt already exist on chain"),
    CPT_NO_PERMISSION(500305, "no permission to perform this cpt task"),
    CPT_JSON_SCHEMA_INVALID(100301, "cpt json schema is invalid"),
    CPT_ID_ILLEGAL(100303, "cptId illegal"),
    CPT_EVENT_LOG_NULL(100304, "cpt event log is null."),
    CREDENTIAL_ERROR(100400, "error occured during processing credential tasks"),
    CREDENTIAL_EXPIRED(100402, "credential is expired"),
    CREDENTIAL_ISSUER_MISMATCH(100403, "issuer weId does not match the weId of credential"),
    CREDENTIAL_SIGNATURE_BROKEN(100405, "credential signature cannot be extracted"),
    CREDENTIAL_ISSUER_NOT_EXISTS(100407, "credential issuer does not exist"),
    CREDENTIAL_ISSUANCE_DATE_ILLEGAL(100408, "credential issuance date illegal"),
    CREDENTIAL_EXPIRE_DATE_ILLEGAL(100409, "expire date illegal"),
    CREDENTIAL_CLAIM_NOT_EXISTS(100410, "claim data does not exist"),
    CREDENTIAL_CLAIM_DATA_ILLEGAL(100411, "claim data illegal"),
    CREDENTIAL_ID_NOT_EXISTS(100412, "credential id does not exist"),
    CREDENTIAL_CONTEXT_NOT_EXISTS(100413, "credential context does not exist"),
    CREDENTIAL_TYPE_IS_NULL(100414, "credential type is null"),
    CREDENTIAL_PRIVATE_KEY_NOT_EXISTS(100415, "private key for signing credential does not exist"),
    CREDENTIAL_CPT_NOT_EXISTS(100416, "cpt does not exist"),
    CREDENTIAL_WEID_DOCUMENT_ILLEGAL(100417, "weid document illegal"),
    CREDENTIAL_ISSUER_INVALID(100418, "credential issuer invalid"),
    CREDENTIAL_EXCEPTION_VERIFYSIGNATURE(100419, "credential verify signature exception"),
    CREDENTIAL_CLAIM_POLICY_NOT_EXIST(100420, "claim policy is null"),
    CREDENTIAL_PUBLIC_KEY_NOT_EXISTS(100421, "public key for verifying credential signature does not exist"),
    CREDENTIAL_SIGNATURE_NOT_EXISTS(100422, "signature for verifying credential does not exist"),
    CREDENTIAL_POLICY_DISCLOSUREVALUE_ILLEGAL(100423, "policy disclosurevalue illegal"),
    CREDENTIAL_DISCLOSUREVALUE_NOTMATCH_SALTVALUE(100424, "disclosurevalue notmatch saltvalue"),
    CREDENTIAL_CPTID_NOTMATCH(100425, "credential cptId notmatch"),
    CREDENTIAL_PRESENTERWEID_NOTMATCH(100426, "credential presenter WeId not match"),
    CREDENTIAL_POLICY_FORMAT_DOSE_NOT_MATCH_CLAIM(100427, "credential disclosure format does not match claim"),
    CREDENTIAL_DISCLOSURE_DATA_TYPE_ILLEGAL(100428, "credential disclosure data illegal"),
    CREDENTIAL_SIGNATURE_TYPE_ILLEGAL(100429, "credential signature type unknown"),
    CREDENTIAL_SALT_ILLEGAL(100430, "credential salt illegal"),
    CREDENTIAL_EVIDENCE_SIGNATURE_BROKEN(100431, "credential evidence cannot be extracted"),
    CREDENTIAL_EVIDENCE_CONTRACT_FAILURE_ILLEAGAL_INPUT(500401, "credential evidence contract failure: illegal input."),
    CREDENTIAL_EVIDENCE_BASE_ERROR(100500, "generic error when processing credential evidence tasks"),
    CREDENTIAL_EVIDENCE_HASH_MISMATCH(100501, "credential evidence hash mismatch"),
    PRESENTATION_CHALLENGE_INVALID(100600, "the challenge is invalid."),
    PRESENTATION_CHALLENGE_WEID_MISMATCH(100601, "the weId of challenge does not match the user's weId."),
    PRESENTATION_POLICY_INVALID(100602, "the presentation policy is invalid."),
    PRESENTATION_CREDENTIALLIST_MISMATCH_CLAIM_POLICY(100603, "the credentiallist of presentation don't match the claim policy."),
    PRESENTATION_WEID_PUBLICKEY_ID_INVALID(100604, "the publicKeyId is invalid."),
    PRESENTATION_CHALLENGE_NONCE_MISMATCH(100605, "the nonce of challenge does not match the nonce of presentation."),
    PRESENTATION_SIGNATURE_MISMATCH(100606, "the signature of presentation does not match the presenter."),
    PRESENTATION_WEID_CREDENTIAL_WEID_MISMATCH(100607, "the presenter weid of presentation does not match the credential."),
    PRESENTATION_CREDENTIAL_CLAIM_WEID_NOT_EXIST(100608, "the weid of the claim of the presentation does not exist."),
    PRESENTATION_POLICY_PUBLISHER_WEID_INVALID(100609, "the publisherWeId of policy is invalid."),
    PRESENTATION_POLICY_PUBLISHER_WEID_NOT_EXIST(100610, "the publisherWeId of policy does not exist."),
    ENCRYPT_KEY_NOT_EXISTS(100700, "the encrypt key not exists."),
    POLICY_SERVICE_NOT_EXISTS(100701, "no policy service."),
    POLICY_SERVICE_CALL_FAIL(100702, "the policy service call fail, please check the error log."),
    ENCRYPT_KEY_NO_PERMISSION(100703, "no permission to get the key."),
    ENCRYPT_KEY_INVALID(100704, "the key is invalid."),
    ENCRYPT_KEY_EXPIRE(100705, "the key is expire."),
    TRANSPORTATION_BASE_ERROR(100800, "suite baes exception error, please check the error log."),
    TRANSPORTATION_PROTOCOL_PROPERTY_ERROR(100801, "the protocol property is error."),
    TRANSPORTATION_PROTOCOL_VERSION_ERROR(100802, "the protocol version is error."),
    TRANSPORTATION_PROTOCOL_ENCODE_ERROR(100803, "the protocol encode is error."),
    TRANSPORTATION_PROTOCOL_STRING_INVALID(100804, "the protocol string is invalid."),
    TRANSPORTATION_PROTOCOL_DATA_INVALID(100805, "the protocol data is invalid."),
    TRANSPORTATION_PROTOCOL_FIELD_INVALID(100806, "the protocol field values cannot be included '|'."),
    TRANSPORTATION_ENCODE_BASE_ERROR(100807, "encode base error, please check the error log."),
    AUTHORITY_ISSUER_ERROR(100200, "error occured during processing authority issuer tasks"),
    AUTHORITY_ISSUER_PRIVATE_KEY_ILLEGAL(100202, "the private key is illegal"),
    AUTHORITY_ISSUER_OPCODE_MISMATCH(100205, "opcode in event log does not match the desired opcode"),
    AUTHORITY_ISSUER_NAME_ILLEGAL(100206, "the registered authority issuer name is illegal"),
    AUTHORITY_ISSUER_ACCVALUE_ILLEAGAL(100207, "the authority issuer accumulator value is illegal (integer value required)"),
    SPECIFIC_ISSUER_TYPE_ILLEGAL(100208, "the specific issuer type is illegal"),
    PRESISTENCE_DATA_KEY_INVALID(100901, "the key of the data is empty."),
    PRESISTENCE_DOMAIN_ILLEGAL(100902, "the domain is illegal."),
    PRESISTENCE_DOMAIN_INVALID(100903, "the domain is invalid."),
    PRESISTENCE_BATCH_SAVE_DATA_MISMATCH(100904, "the data does not match for batch save."),
    AUTHORITY_ISSUER_CONTRACT_ERROR_ALREADY_EXIST(500201, "the authority issuer contract error: the subject already exists"),
    AUTHORITY_ISSUER_CONTRACT_ERROR_NOT_EXISTS(500202, "the authority issuer contract error: the subject does not exist"),
    AUTHORITY_ISSUER_CONTRACT_ERROR_NAME_ALREADY_EXISTS(500203, "the authority issuer name already exists."),
    SPECIFIC_ISSUER_CONTRACT_ERROR_ALREADY_EXISTS(500501, "the specific issuer type or address already exists."),
    SPECIFIC_ISSUER_CONTRACT_ERROR_ALREADY_NOT_EXIST(500502, "the specific issuer type or address does not exist."),
    WEID_INVALID(100101, "the weIdentity DID is invalid."),
    WEID_PUBLICKEY_INVALID(100102, "the input public key is invalid."),
    WEID_PRIVATEKEY_INVALID(100103, "the input private key is invalid, please check and input your private key."),
    WEID_DOES_NOT_EXIST(100104, "the weid does not exist on blockchain."),
    WEID_ALREADY_EXIST(100105, "the weid has already exist on blockchain."),
    WEID_PRIVATEKEY_DOES_NOT_MATCH(100106, "the private key does not match the current weid."),
    WEID_KEYPAIR_CREATE_FAILED(100107, "create keypair faild."),
    WEID_PUBLICKEY_AND_PRIVATEKEY_NOT_MATCHED(100108, "the public key and private key are not matched."),
    WEID_AUTHORITY_INVALID(100109, "the authority of the weIdentity DID is invalid."),
    WEID_SERVICE_TYPE_OVERLIMIT(100110, "the length of service type is overlimit."),
    TRANSACTION_TIMEOUT(160001, "the transaction is timeout."),
    TRANSACTION_EXECUTE_ERROR(160002, "the transaction does not correctly executed."),
    ILLEGAL_INPUT(160004, "input parameter is illegal."),
    LOAD_CONTRACT_FAILED(160005, "load contract failed."),
    LOAD_WEB3J_FAILED(160006, "load web3j failed."),
    BASE_ERROR(160007, "baes exception error, please check the error log."),
    DATA_TYPE_CASE_ERROR(160008, "data type cast exception error, please check the error log."),
    DIRECT_ROUTE_REQUEST_TIMEOUT(160009, "amop timeout"),
    DIRECT_ROUTE_MSG_BASE_ERROR(160010, "amop response messageBody error."),
    SQL_EXECUTE_FAILED(160011, "sql execute failed."),
    AMOP_MSG_CALLBACK_SERVER_SIDE_NO_HANDLE(160012, "amop server side has no direct route callback."),
    SQL_GET_CONNECTION_ERROR(160013, "can not get the connection from pool, please check the error log."),
    UNKNOW_ERROR(160003, "unknow error, please check the error log.");

    private int code;
    private String codeDesc;

    private ErrorCode(int code, String codeDesc) {
        this.code = code;
        this.codeDesc = codeDesc;
    }

    public int getCode() {
        return this.code;
    }

    protected void setCode(int code) {
        this.code = code;
    }

    public String getCodeDesc() {
        return this.codeDesc;
    }

    protected void setCodeDesc(String codeDesc) {
        this.codeDesc = codeDesc;
    }

    public static ErrorCode getTypeByErrorCode(int errorCode) {
        for (ErrorCode type : ErrorCode.values()) {
            if (type.getCode() != errorCode) continue;
            return type;
        }
        return UNKNOW_ERROR;
    }
}

