/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.contract.deploy;

import com.webank.weid.config.FiscoConfig;
import com.webank.weid.contract.deploy.v1.DeployContractV1;
import com.webank.weid.contract.deploy.v2.DeployContractV2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeployContract {
    private static final Logger logger = LoggerFactory.getLogger(DeployContract.class);
    protected static final FiscoConfig fiscoConfig = new FiscoConfig();

    public static void main(String[] args) {
        if (fiscoConfig.getVersion().startsWith("1")) {
            DeployContractV1.deployContract();
        } else {
            DeployContractV2.deployContract();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeAddressToFile(String contractAddress, String fileName) {
        OutputStreamWriter ow = null;
        try {
            boolean flag = true;
            File file = new File(fileName);
            if (file.exists()) {
                flag = file.delete();
            }
            if (!flag) {
                logger.error("writeAddressToFile() delete file is fail.");
                return;
            }
            ow = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), StandardCharsets.UTF_8);
            String content = new StringBuffer().append(contractAddress).toString();
            ow.write(content);
            ow.close();
        }
        catch (IOException e) {
            logger.error("writer file exception", (Throwable)e);
        }
        finally {
            if (ow != null) {
                try {
                    ow.close();
                }
                catch (IOException e) {
                    logger.error("io close exception", (Throwable)e);
                }
            }
        }
    }

    static {
        if (!fiscoConfig.load()) {
            logger.error("[BaseService] Failed to load Fisco-BCOS blockchain node information.");
            System.exit(1);
        }
    }
}

