/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.contract.deploy.v1;

import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.deploy.DeployContract;
import com.webank.weid.contract.v1.AuthorityIssuerController;
import com.webank.weid.contract.v1.AuthorityIssuerData;
import com.webank.weid.contract.v1.CommitteeMemberController;
import com.webank.weid.contract.v1.CommitteeMemberData;
import com.webank.weid.contract.v1.CptController;
import com.webank.weid.contract.v1.CptData;
import com.webank.weid.contract.v1.EvidenceFactory;
import com.webank.weid.contract.v1.RoleController;
import com.webank.weid.contract.v1.SpecificIssuerController;
import com.webank.weid.contract.v1.SpecificIssuerData;
import com.webank.weid.contract.v1.WeIdContract;
import com.webank.weid.service.BaseService;
import com.webank.weid.util.WeIdUtils;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.crypto.Credentials;
import org.bcos.web3j.crypto.GenCredential;
import org.bcos.web3j.protocol.Web3j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployContractV1
extends DeployContract {
    private static final Logger logger = LoggerFactory.getLogger(DeployContractV1.class);
    private static final Integer DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS = 15;
    private static Credentials credentials;
    private static Web3j web3j;

    private static boolean initCredentials() {
        logger.info("[DeployContractV1] begin to init credentials..");
        credentials = GenCredential.create();
        if (credentials == null) {
            logger.error("[DeployContractV1] credentials init failed. ");
            return false;
        }
        String privateKey = credentials.getEcKeyPair().getPrivateKey().toString();
        DeployContractV1.writeAddressToFile(privateKey, "ecdsa_key");
        return true;
    }

    protected static void initWeb3j() {
        if (web3j == null) {
            web3j = (Web3j)BaseService.getWeb3j();
        }
    }

    public static void deployContract() {
        DeployContractV1.initWeb3j();
        DeployContractV1.initCredentials();
        String weIdContractAddress = DeployContractV1.deployWeIdContract();
        String roleControllerAddress = DeployContractV1.deployRoleControllerContracts();
        Map<String, String> addrList = DeployContractV1.deployIssuerContracts(roleControllerAddress);
        if (addrList.containsKey("AuthorityIssuerData")) {
            String authorityIssuerDataAddress = addrList.get("AuthorityIssuerData");
            DeployContractV1.deployCptContracts(authorityIssuerDataAddress, weIdContractAddress, roleControllerAddress);
        }
        DeployContractV1.deployEvidenceContracts();
    }

    private static String deployWeIdContract() {
        if (web3j == null) {
            DeployContractV1.initWeb3j();
        }
        Future f = WeIdContract.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE);
        try {
            WeIdContract weIdContract = (WeIdContract)f.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            String contractAddress = weIdContract.getContractAddress();
            DeployContractV1.writeAddressToFile(contractAddress, "weIdContract.address");
            return contractAddress;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("WeIdContract deploy exception", (Throwable)e);
            return "";
        }
    }

    private static String deployCptContracts(String authorityIssuerDataAddress, String weIdContractAddress, String roleControllerAddress) {
        if (web3j == null) {
            DeployContractV1.initWeb3j();
        }
        try {
            Future f1 = CptData.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE, (Address)new Address(authorityIssuerDataAddress));
            CptData cptData = (CptData)f1.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            String cptDataAddress = cptData.getContractAddress();
            Future f2 = CptController.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE, (Address)new Address(cptDataAddress), (Address)new Address(weIdContractAddress));
            CptController cptController = (CptController)f2.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            String cptControllerAddress = cptController.getContractAddress();
            DeployContractV1.writeAddressToFile(cptControllerAddress, "cptController.address");
            Future f3 = cptController.setRoleController(new Address(roleControllerAddress));
            f3.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("CptController deploy exception", (Throwable)e);
        }
        return "";
    }

    private static String deployRoleControllerContracts() {
        if (web3j == null) {
            DeployContractV1.initWeb3j();
        }
        try {
            Future f1 = RoleController.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE);
            RoleController roleController = (RoleController)f1.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            return roleController.getContractAddress();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("RoleController deploy exception", (Throwable)e);
            return "";
        }
    }

    private static Map<String, String> deployIssuerContracts(String roleControllerAddress) {
        String authorityIssuerControllerAddress;
        String authorityIssuerDataAddress;
        String committeeMemberDataAddress;
        if (web3j == null) {
            DeployContractV1.initWeb3j();
        }
        HashMap<String, String> issuerAddressList = new HashMap<String, String>();
        try {
            Future f2 = CommitteeMemberData.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE, (Address)new Address(roleControllerAddress));
            CommitteeMemberData committeeMemberData = (CommitteeMemberData)f2.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            committeeMemberDataAddress = committeeMemberData.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(committeeMemberDataAddress))) {
                issuerAddressList.put("CommitteeMemberData", committeeMemberDataAddress);
            }
        }
        catch (Exception e) {
            logger.error("CommitteeMemberData deployment error:", (Throwable)e);
            return issuerAddressList;
        }
        try {
            Future f3 = CommitteeMemberController.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE, (Address)new Address(committeeMemberDataAddress), (Address)new Address(roleControllerAddress));
            CommitteeMemberController committeeMemberController = (CommitteeMemberController)f3.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            String committeeMemberControllerAddress = committeeMemberController.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(committeeMemberControllerAddress))) {
                issuerAddressList.put("CommitteeMemberController", committeeMemberControllerAddress);
            }
        }
        catch (Exception e) {
            logger.error("CommitteeMemberController deployment error:", (Throwable)e);
            return issuerAddressList;
        }
        try {
            Future f4 = AuthorityIssuerData.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE, (Address)new Address(roleControllerAddress));
            AuthorityIssuerData authorityIssuerData = (AuthorityIssuerData)f4.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            authorityIssuerDataAddress = authorityIssuerData.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(authorityIssuerDataAddress))) {
                issuerAddressList.put("AuthorityIssuerData", authorityIssuerDataAddress);
            }
        }
        catch (Exception e) {
            logger.error("AuthorityIssuerData deployment error:", (Throwable)e);
            return issuerAddressList;
        }
        try {
            Future f5 = AuthorityIssuerController.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE, (Address)new Address(authorityIssuerDataAddress), (Address)new Address(roleControllerAddress));
            AuthorityIssuerController authorityIssuerController = (AuthorityIssuerController)f5.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            authorityIssuerControllerAddress = authorityIssuerController.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(authorityIssuerControllerAddress))) {
                issuerAddressList.put("AuthorityIssuerController", authorityIssuerControllerAddress);
            }
        }
        catch (Exception e) {
            logger.error("AuthorityIssuerController deployment error:", (Throwable)e);
            return issuerAddressList;
        }
        try {
            DeployContractV1.writeAddressToFile(authorityIssuerControllerAddress, "authorityIssuer.address");
        }
        catch (Exception e) {
            logger.error("Write error:", (Throwable)e);
        }
        String specificIssuerDataAddress = "";
        try {
            Future f6 = SpecificIssuerData.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE);
            SpecificIssuerData specificIssuerData = (SpecificIssuerData)f6.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            specificIssuerDataAddress = specificIssuerData.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(specificIssuerDataAddress))) {
                issuerAddressList.put("SpecificIssuerData", specificIssuerDataAddress);
            }
        }
        catch (Exception e) {
            logger.error("SpecificIssuerData deployment error:", (Throwable)e);
        }
        try {
            Future f7 = SpecificIssuerController.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE, (Address)new Address(specificIssuerDataAddress), (Address)new Address(roleControllerAddress));
            SpecificIssuerController specificIssuerController = (SpecificIssuerController)f7.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            String specificIssuerControllerAddress = specificIssuerController.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(specificIssuerControllerAddress))) {
                issuerAddressList.put("SpecificIssuerController", specificIssuerControllerAddress);
            }
            try {
                DeployContractV1.writeAddressToFile(specificIssuerControllerAddress, "specificIssuer.address");
            }
            catch (Exception e) {
                logger.error("Write error:", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("SpecificIssuerController deployment error:", (Throwable)e);
        }
        return issuerAddressList;
    }

    private static String deployEvidenceContracts() {
        if (web3j == null) {
            DeployContractV1.initWeb3j();
        }
        try {
            Future f = EvidenceFactory.deploy((Web3j)web3j, (Credentials)credentials, (BigInteger)WeIdConstant.GAS_PRICE, (BigInteger)WeIdConstant.GAS_LIMIT, (BigInteger)WeIdConstant.INILITIAL_VALUE);
            EvidenceFactory evidenceFactory = (EvidenceFactory)f.get(DEFAULT_DEPLOY_CONTRACTS_TIMEOUT_IN_SECONDS.intValue(), TimeUnit.SECONDS);
            String evidenceFactoryAddress = evidenceFactory.getContractAddress();
            DeployContractV1.writeAddressToFile(evidenceFactoryAddress, "evidenceController.address");
            return evidenceFactoryAddress;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("EvidenceFactory deploy exception", (Throwable)e);
            return "";
        }
    }
}

