/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.contract.deploy.v2;

import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.deploy.DeployContract;
import com.webank.weid.contract.v2.AuthorityIssuerController;
import com.webank.weid.contract.v2.AuthorityIssuerData;
import com.webank.weid.contract.v2.CommitteeMemberController;
import com.webank.weid.contract.v2.CommitteeMemberData;
import com.webank.weid.contract.v2.CptController;
import com.webank.weid.contract.v2.CptData;
import com.webank.weid.contract.v2.EvidenceFactory;
import com.webank.weid.contract.v2.RoleController;
import com.webank.weid.contract.v2.SpecificIssuerController;
import com.webank.weid.contract.v2.SpecificIssuerData;
import com.webank.weid.contract.v2.WeIdContract;
import com.webank.weid.service.BaseService;
import com.webank.weid.util.WeIdUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.fisco.bcos.web3j.abi.datatypes.Address;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.crypto.gm.GenCredential;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployContractV2
extends DeployContract {
    private static final Logger logger = LoggerFactory.getLogger(DeployContractV2.class);
    private static Credentials credentials;
    private static Web3j web3j;

    private static boolean initCredentials() {
        logger.info("[DeployContractV1] begin to init credentials..");
        credentials = GenCredential.create();
        if (credentials == null) {
            logger.error("[DeployContractV1] credentials init failed. ");
            return false;
        }
        String privateKey = credentials.getEcKeyPair().getPrivateKey().toString();
        DeployContractV2.writeAddressToFile(privateKey, "ecdsa_key");
        return true;
    }

    protected static void initWeb3j() {
        if (web3j == null) {
            web3j = (Web3j)BaseService.getWeb3j();
        }
    }

    public static void deployContract() {
        DeployContractV2.initWeb3j();
        DeployContractV2.initCredentials();
        String weIdContractAddress = DeployContractV2.deployWeIdContract();
        String roleControllerAddress = DeployContractV2.deployRoleControllerContracts();
        Map<String, String> addrList = DeployContractV2.deployIssuerContracts(roleControllerAddress);
        if (addrList.containsKey("AuthorityIssuerData")) {
            String authorityIssuerDataAddress = addrList.get("AuthorityIssuerData");
            DeployContractV2.deployCptContracts(authorityIssuerDataAddress, weIdContractAddress, roleControllerAddress);
        }
        DeployContractV2.deployEvidenceContracts();
    }

    private static String deployRoleControllerContracts() {
        if (web3j == null) {
            DeployContractV2.initWeb3j();
        }
        RoleController roleController = null;
        try {
            roleController = (RoleController)RoleController.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT)).send();
            return roleController.getContractAddress();
        }
        catch (Exception e) {
            logger.error("RoleController deploy exception", (Throwable)e);
            return "";
        }
    }

    private static String deployWeIdContract() {
        if (web3j == null) {
            DeployContractV2.initWeb3j();
        }
        WeIdContract weIdContract = null;
        try {
            weIdContract = (WeIdContract)WeIdContract.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT)).send();
        }
        catch (Exception e) {
            logger.error("WeIdContract deploy error.", (Throwable)e);
            return "";
        }
        String contractAddress = weIdContract.getContractAddress();
        DeployContractV2.writeAddressToFile(contractAddress, "weIdContract.address");
        return contractAddress;
    }

    private static String deployCptContracts(String authorityIssuerDataAddress, String weIdContractAddress, String roleControllerAddress) {
        if (web3j == null) {
            DeployContractV2.initWeb3j();
        }
        try {
            CptData cptData = (CptData)CptData.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT), (String)authorityIssuerDataAddress).send();
            String cptDataAddress = cptData.getContractAddress();
            CptController cptController = (CptController)CptController.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT), (String)cptDataAddress, (String)weIdContractAddress).send();
            String cptControllerAddress = cptController.getContractAddress();
            DeployContractV2.writeAddressToFile(cptControllerAddress, "cptController.address");
            TransactionReceipt receipt = (TransactionReceipt)cptController.setRoleController(roleControllerAddress).send();
            if (receipt == null) {
                logger.error("CptController deploy exception");
            }
        }
        catch (Exception e) {
            logger.error("CptController deploy exception", (Throwable)e);
        }
        return "";
    }

    private static Map<String, String> deployIssuerContracts(String roleControllerAddress) {
        String authorityIssuerControllerAddress;
        String authorityIssuerDataAddress;
        String committeeMemberDataAddress;
        if (web3j == null) {
            DeployContractV2.initWeb3j();
        }
        HashMap<String, String> issuerAddressList = new HashMap<String, String>();
        try {
            CommitteeMemberData committeeMemberData = (CommitteeMemberData)CommitteeMemberData.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT), (String)roleControllerAddress).send();
            committeeMemberDataAddress = committeeMemberData.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(committeeMemberDataAddress))) {
                issuerAddressList.put("CommitteeMemberData", committeeMemberDataAddress);
            }
        }
        catch (Exception e) {
            logger.error("CommitteeMemberData deployment error:", (Throwable)e);
            return issuerAddressList;
        }
        try {
            CommitteeMemberController committeeMemberController = (CommitteeMemberController)CommitteeMemberController.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT), (String)committeeMemberDataAddress, (String)roleControllerAddress).send();
            String committeeMemberControllerAddress = committeeMemberController.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(committeeMemberControllerAddress))) {
                issuerAddressList.put("CommitteeMemberController", committeeMemberControllerAddress);
            }
        }
        catch (Exception e) {
            logger.error("CommitteeMemberController deployment error:", (Throwable)e);
            return issuerAddressList;
        }
        try {
            AuthorityIssuerData authorityIssuerData = (AuthorityIssuerData)AuthorityIssuerData.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT), (String)roleControllerAddress).send();
            authorityIssuerDataAddress = authorityIssuerData.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(authorityIssuerDataAddress))) {
                issuerAddressList.put("AuthorityIssuerData", authorityIssuerDataAddress);
            }
        }
        catch (Exception e) {
            logger.error("AuthorityIssuerData deployment error:", (Throwable)e);
            return issuerAddressList;
        }
        try {
            AuthorityIssuerController authorityIssuerController = (AuthorityIssuerController)AuthorityIssuerController.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT), (String)authorityIssuerDataAddress, (String)roleControllerAddress).send();
            authorityIssuerControllerAddress = authorityIssuerController.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(authorityIssuerControllerAddress))) {
                issuerAddressList.put("AuthorityIssuerController", authorityIssuerControllerAddress);
            }
        }
        catch (Exception e) {
            logger.error("AuthorityIssuerController deployment error:", (Throwable)e);
            return issuerAddressList;
        }
        try {
            DeployContractV2.writeAddressToFile(authorityIssuerControllerAddress, "authorityIssuer.address");
        }
        catch (Exception e) {
            logger.error("Write error:", (Throwable)e);
        }
        String specificIssuerDataAddress = "";
        try {
            SpecificIssuerData specificIssuerData = (SpecificIssuerData)SpecificIssuerData.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT)).send();
            specificIssuerDataAddress = specificIssuerData.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(specificIssuerDataAddress))) {
                issuerAddressList.put("SpecificIssuerData", specificIssuerDataAddress);
            }
        }
        catch (Exception e) {
            logger.error("SpecificIssuerData deployment error:", (Throwable)e);
        }
        try {
            SpecificIssuerController specificIssuerController = (SpecificIssuerController)SpecificIssuerController.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT), (String)specificIssuerDataAddress, (String)roleControllerAddress).send();
            String specificIssuerControllerAddress = specificIssuerController.getContractAddress();
            if (!WeIdUtils.isEmptyAddress(new Address(specificIssuerControllerAddress))) {
                issuerAddressList.put("SpecificIssuerController", specificIssuerControllerAddress);
            }
            try {
                DeployContractV2.writeAddressToFile(specificIssuerControllerAddress, "specificIssuer.address");
            }
            catch (Exception e) {
                logger.error("Write error:", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("SpecificIssuerController deployment error:", (Throwable)e);
        }
        return issuerAddressList;
    }

    private static String deployEvidenceContracts() {
        if (web3j == null) {
            DeployContractV2.initWeb3j();
        }
        try {
            EvidenceFactory evidenceFactory = (EvidenceFactory)EvidenceFactory.deploy((Web3j)web3j, (Credentials)credentials, (ContractGasProvider)new StaticGasProvider(WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT)).send();
            String evidenceFactoryAddress = evidenceFactory.getContractAddress();
            DeployContractV2.writeAddressToFile(evidenceFactoryAddress, "evidenceController.address");
            return evidenceFactoryAddress;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("EvidenceFactory deploy exception", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("EvidenceFactory deploy exception", (Throwable)e);
        }
        return "";
    }
}

