/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.protocol.base;

import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.protocol.base.Version;
import com.webank.weid.protocol.inf.RawSerializer;
import com.webank.weid.util.DataToolUtils;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Challenge
extends Version
implements RawSerializer {
    private static final Logger logger = LoggerFactory.getLogger(Challenge.class);
    private static final long serialVersionUID = 3783172794625195471L;
    private String weId;
    private String nonce;

    public static Challenge create(String userWeId, String seed) {
        SecureRandom random = new SecureRandom();
        String randomSeed = seed + DataToolUtils.getUuId32();
        random.setSeed(randomSeed.getBytes());
        byte[] bytes = new byte[15];
        random.nextBytes(bytes);
        String nonce = Base64.encodeBase64String((byte[])bytes);
        Challenge challenge = new Challenge();
        challenge.setNonce(nonce);
        challenge.setWeId(userWeId);
        return challenge;
    }

    @Override
    public String toJson() {
        return DataToolUtils.addTagFromToJson(DataToolUtils.serialize(this));
    }

    public static Challenge fromJson(String challengeJson) {
        if (StringUtils.isBlank((CharSequence)challengeJson)) {
            logger.error("create Challenge with JSON String failed, the Challenge JSON String is null");
            throw new DataTypeCastException("the Challenge JSON String is null.");
        }
        String challengeString = challengeJson;
        if (DataToolUtils.isValidFromToJson(challengeJson)) {
            challengeString = DataToolUtils.removeTagFromToJson(challengeJson);
        }
        return DataToolUtils.deserialize(challengeString, Challenge.class);
    }

    @Override
    public String toRawData() {
        return this.nonce;
    }

    private Challenge() {
        this.setVersion(1);
    }

    public String getWeId() {
        return this.weId;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setWeId(String weId) {
        this.weId = weId;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }
}

