/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.protocol.base;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.protocol.inf.IProof;
import com.webank.weid.protocol.inf.JsonSerializer;
import com.webank.weid.util.CredentialPojoUtils;
import com.webank.weid.util.DataToolUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialPojo
implements IProof,
JsonSerializer {
    private static final Logger logger = LoggerFactory.getLogger(CredentialPojo.class);
    private static final long serialVersionUID = 8197843857223846978L;
    private String context;
    private String id;
    private Integer cptId;
    private String issuer;
    private Long issuanceDate;
    private Long expirationDate;
    private Map<String, Object> claim;
    private Map<String, Object> proof;
    private List<String> type;

    public void addType(String typeValue) {
        if (this.type == null) {
            this.type = new ArrayList<String>();
        }
        this.type.add(typeValue);
    }

    public String getSignature() {
        return this.toString(this.getValueFromProof(this.proof, "signatureValue"));
    }

    public String getProofType() {
        return this.toString(this.getValueFromProof(this.proof, "type"));
    }

    public Map<String, Object> getSalt() {
        return (Map)this.getValueFromProof(this.proof, "salt");
    }

    public void setSalt(Map<String, Object> salt) {
        this.putProofValue("salt", salt);
    }

    public void putProofValue(String key, Object value) {
        if (this.proof == null) {
            this.proof = new HashMap<String, Object>();
        }
        this.proof.put(key, value);
    }

    @Override
    public String toJson() {
        String json = DataToolUtils.convertTimestampToUtc(DataToolUtils.serialize(this));
        return DataToolUtils.addTagFromToJson(json);
    }

    public static CredentialPojo fromJson(String credentialJson) {
        if (StringUtils.isBlank((CharSequence)credentialJson)) {
            logger.error("create credential with JSON String failed, the credential JSON String is null");
            throw new DataTypeCastException("the credential JSON String is null");
        }
        String credentialString = credentialJson;
        if (DataToolUtils.isValidFromToJson(credentialJson)) {
            credentialString = DataToolUtils.removeTagFromToJson(credentialJson);
        }
        CredentialPojo credentialPojo = DataToolUtils.deserialize(DataToolUtils.convertUtcToTimestamp(credentialString), CredentialPojo.class);
        ErrorCode checkResp = CredentialPojoUtils.isCredentialPojoValid(credentialPojo);
        if (ErrorCode.SUCCESS.getCode() != checkResp.getCode()) {
            logger.error("create CredentialPojo with JSON String failed, {}", (Object)checkResp.getCodeDesc());
            throw new DataTypeCastException(checkResp.getCodeDesc());
        }
        if (!CredentialPojoUtils.validClaimAndSaltForMap(credentialPojo.getClaim(), credentialPojo.getSalt())) {
            logger.error("create PresentationE with JSON String failed, claim and salt of credentialPojo not match.");
            throw new DataTypeCastException("claim and salt of credentialPojo not match.");
        }
        return credentialPojo;
    }

    public String getContext() {
        return this.context;
    }

    public String getId() {
        return this.id;
    }

    public Integer getCptId() {
        return this.cptId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public Long getIssuanceDate() {
        return this.issuanceDate;
    }

    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public Map<String, Object> getClaim() {
        return this.claim;
    }

    public Map<String, Object> getProof() {
        return this.proof;
    }

    public List<String> getType() {
        return this.type;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCptId(Integer cptId) {
        this.cptId = cptId;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setIssuanceDate(Long issuanceDate) {
        this.issuanceDate = issuanceDate;
    }

    public void setExpirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setClaim(Map<String, Object> claim) {
        this.claim = claim;
    }

    public void setProof(Map<String, Object> proof) {
        this.proof = proof;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CredentialPojo)) {
            return false;
        }
        CredentialPojo other = (CredentialPojo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Integer this$cptId = this.getCptId();
        Integer other$cptId = other.getCptId();
        if (this$cptId == null ? other$cptId != null : !((Object)this$cptId).equals(other$cptId)) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        Long this$issuanceDate = this.getIssuanceDate();
        Long other$issuanceDate = other.getIssuanceDate();
        if (this$issuanceDate == null ? other$issuanceDate != null : !((Object)this$issuanceDate).equals(other$issuanceDate)) {
            return false;
        }
        Long this$expirationDate = this.getExpirationDate();
        Long other$expirationDate = other.getExpirationDate();
        if (this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate)) {
            return false;
        }
        Map<String, Object> this$claim = this.getClaim();
        Map<String, Object> other$claim = other.getClaim();
        if (this$claim == null ? other$claim != null : !((Object)this$claim).equals(other$claim)) {
            return false;
        }
        Map<String, Object> this$proof = this.getProof();
        Map<String, Object> other$proof = other.getProof();
        if (this$proof == null ? other$proof != null : !((Object)this$proof).equals(other$proof)) {
            return false;
        }
        List<String> this$type = this.getType();
        List<String> other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CredentialPojo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Integer $cptId = this.getCptId();
        result = result * 59 + ($cptId == null ? 43 : ((Object)$cptId).hashCode());
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        Long $issuanceDate = this.getIssuanceDate();
        result = result * 59 + ($issuanceDate == null ? 43 : ((Object)$issuanceDate).hashCode());
        Long $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        Map<String, Object> $claim = this.getClaim();
        result = result * 59 + ($claim == null ? 43 : ((Object)$claim).hashCode());
        Map<String, Object> $proof = this.getProof();
        result = result * 59 + ($proof == null ? 43 : ((Object)$proof).hashCode());
        List<String> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    public String toString() {
        return "CredentialPojo(context=" + this.getContext() + ", id=" + this.getId() + ", cptId=" + this.getCptId() + ", issuer=" + this.getIssuer() + ", issuanceDate=" + this.getIssuanceDate() + ", expirationDate=" + this.getExpirationDate() + ", claim=" + this.getClaim() + ", proof=" + this.getProof() + ", type=" + this.getType() + ")";
    }
}

