/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.protocol.base;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.protocol.base.CredentialPojo;
import com.webank.weid.protocol.base.WeIdAuthentication;
import com.webank.weid.protocol.inf.IProof;
import com.webank.weid.protocol.inf.RawSerializer;
import com.webank.weid.util.CredentialPojoUtils;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.WeIdUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresentationE
implements RawSerializer,
IProof {
    private static final Logger logger = LoggerFactory.getLogger(PresentationE.class);
    private static final long serialVersionUID = -595605743843891841L;
    private List<String> context = new ArrayList<String>();
    private List<String> type = new ArrayList<String>();
    private List<CredentialPojo> verifiableCredential;
    private Map<String, Object> proof;

    public String getVerificationMethod() {
        return this.toString(this.getValueFromProof(this.proof, "verificationMethod"));
    }

    public String getNonce() {
        return this.toString(this.getValueFromProof(this.proof, "nonce"));
    }

    public String getSignature() {
        return this.toString(this.getValueFromProof(this.proof, "signatureValue"));
    }

    public void putProofValue(String key, Object value) {
        if (this.proof == null) {
            this.proof = new HashMap<String, Object>();
        }
        this.proof.put(key, value);
    }

    @Override
    public String toJson() {
        String json = DataToolUtils.convertTimestampToUtc(DataToolUtils.serialize(this));
        return DataToolUtils.addTagFromToJson(json);
    }

    public static PresentationE fromJson(String presentationJson) {
        PresentationE presentationE;
        if (StringUtils.isBlank((CharSequence)presentationJson)) {
            logger.error("create PresentationE with JSON String failed, the presentation JSON String is null");
            throw new DataTypeCastException("the presentation JSON String is null");
        }
        String presentationString = presentationJson;
        if (DataToolUtils.isValidFromToJson(presentationJson)) {
            presentationString = DataToolUtils.removeTagFromToJson(presentationJson);
        }
        if ((presentationE = DataToolUtils.deserialize(DataToolUtils.convertUtcToTimestamp(presentationString), PresentationE.class)) == null || presentationE.getVerifiableCredential() == null || presentationE.getVerifiableCredential().isEmpty()) {
            logger.error("create PresentationE with JSON String failed, due to convert UTC to Timestamp error");
            throw new DataTypeCastException("convert UTC to Timestamp error");
        }
        for (CredentialPojo credentialPojo : presentationE.getVerifiableCredential()) {
            ErrorCode checkResp = CredentialPojoUtils.isCredentialPojoValid(credentialPojo);
            if (ErrorCode.SUCCESS.getCode() != checkResp.getCode()) {
                logger.error("create PresentationE with JSON String failed, {}", (Object)checkResp.getCodeDesc());
                throw new DataTypeCastException(checkResp.getCodeDesc());
            }
            if (CredentialPojoUtils.validClaimAndSaltForMap(credentialPojo.getClaim(), credentialPojo.getSalt())) continue;
            logger.error("create PresentationE with JSON String failed, claim and salt of credentialPojo not match.");
            throw new DataTypeCastException("claim and salt of credentialPojo not match.");
        }
        return presentationE;
    }

    public boolean push(CredentialPojo credentialPojo) {
        if (this.verifiableCredential == null || credentialPojo == null) {
            logger.error("[push] the credentialPojo is null.");
            return false;
        }
        ErrorCode checkResp = CredentialPojoUtils.isCredentialPojoValid(credentialPojo);
        if (ErrorCode.SUCCESS.getCode() != checkResp.getCode()) {
            logger.error("[push] the credentialPojo is invalid.");
            return false;
        }
        this.verifiableCredential.add(credentialPojo);
        logger.info("[push] the credentialPojo is added.");
        return true;
    }

    public boolean commit(WeIdAuthentication weIdAuthentication) {
        if (weIdAuthentication == null || weIdAuthentication.getWeIdPrivateKey() == null || weIdAuthentication.getWeId() == null) {
            logger.error("[commit] the weIdAuthentication is null.");
            return false;
        }
        if (!WeIdUtils.validatePrivateKeyWeIdMatches(weIdAuthentication.getWeIdPrivateKey(), weIdAuthentication.getWeId())) {
            logger.error("[commit] the private key does not match the current weid.");
            return false;
        }
        if (!weIdAuthentication.getWeIdPublicKeyId().equals(this.getVerificationMethod())) {
            logger.error("[commit] the public key id does not match the presentation.");
            return false;
        }
        String signature = DataToolUtils.sign(this.toRawData(), weIdAuthentication.getWeIdPrivateKey().getPrivateKey());
        this.putProofValue("signatureValue", signature);
        logger.info("[commit] commit credential with weIdAuthentication is success.");
        return true;
    }

    @Override
    public String toRawData() {
        PresentationE presentation = DataToolUtils.clone(this);
        presentation.proof = null;
        return DataToolUtils.serialize(presentation);
    }

    public List<String> getContext() {
        return this.context;
    }

    public List<String> getType() {
        return this.type;
    }

    public List<CredentialPojo> getVerifiableCredential() {
        return this.verifiableCredential;
    }

    public Map<String, Object> getProof() {
        return this.proof;
    }

    public void setContext(List<String> context) {
        this.context = context;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public void setVerifiableCredential(List<CredentialPojo> verifiableCredential) {
        this.verifiableCredential = verifiableCredential;
    }

    public void setProof(Map<String, Object> proof) {
        this.proof = proof;
    }

    public String toString() {
        return "PresentationE(context=" + this.getContext() + ", type=" + this.getType() + ", verifiableCredential=" + this.getVerifiableCredential() + ", proof=" + this.getProof() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresentationE)) {
            return false;
        }
        PresentationE other = (PresentationE)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$context = this.getContext();
        List<String> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        List<String> this$type = this.getType();
        List<String> other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        List<CredentialPojo> this$verifiableCredential = this.getVerifiableCredential();
        List<CredentialPojo> other$verifiableCredential = other.getVerifiableCredential();
        if (this$verifiableCredential == null ? other$verifiableCredential != null : !((Object)this$verifiableCredential).equals(other$verifiableCredential)) {
            return false;
        }
        Map<String, Object> this$proof = this.getProof();
        Map<String, Object> other$proof = other.getProof();
        return !(this$proof == null ? other$proof != null : !((Object)this$proof).equals(other$proof));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PresentationE;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        List<String> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        List<CredentialPojo> $verifiableCredential = this.getVerifiableCredential();
        result = result * 59 + ($verifiableCredential == null ? 43 : ((Object)$verifiableCredential).hashCode());
        Map<String, Object> $proof = this.getProof();
        result = result * 59 + ($proof == null ? 43 : ((Object)$proof).hashCode());
        return result;
    }
}

