/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.protocol.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.webank.weid.protocol.base.ClaimPolicy;
import com.webank.weid.protocol.base.Version;
import com.webank.weid.protocol.inf.JsonSerializer;
import com.webank.weid.util.DataToolUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresentationPolicyE
extends Version
implements JsonSerializer {
    private static final long serialVersionUID = 3607089314849566766L;
    private static final Logger logger = LoggerFactory.getLogger(PresentationPolicyE.class);
    private Integer id;
    private String orgId;
    private String policyPublisherWeId;
    private Map<Integer, ClaimPolicy> policy;
    private Map<String, String> extra;

    private PresentationPolicyE() {
    }

    public static PresentationPolicyE create(String policyFileName) {
        PresentationPolicyE policy = null;
        try {
            JsonNode jsonNode = JsonLoader.fromResource((String)("/" + policyFileName));
            if (jsonNode == null) {
                logger.error("can not find the {} file in your classpath.", (Object)policyFileName);
                return policy;
            }
            policy = PresentationPolicyE.fromJson(jsonNode.toString());
        }
        catch (IOException e) {
            logger.error("create PresentationPolicyE has error, please check the log.", (Throwable)e);
        }
        return policy;
    }

    public static PresentationPolicyE fromJson(String json) {
        PresentationPolicyE policy = null;
        try {
            HashMap policyMap = DataToolUtils.deserialize(json, HashMap.class);
            HashMap claimMap = (HashMap)policyMap.get("policy");
            Iterator it = claimMap.keySet().iterator();
            while (it.hasNext()) {
                HashMap claim = (HashMap)claimMap.get(it.next());
                HashMap disclosedMap = (HashMap)claim.get("fieldsToBeDisclosed");
                claim.put("fieldsToBeDisclosed", DataToolUtils.serialize(disclosedMap));
            }
            String value = DataToolUtils.serialize(policyMap);
            return DataToolUtils.deserialize(value, PresentationPolicyE.class);
        }
        catch (Exception e) {
            logger.error("create PresentationPolicyE has error, please check the log.", (Throwable)e);
            return policy;
        }
    }

    @Override
    public String toJson() {
        String jsonString = DataToolUtils.serialize(this);
        HashMap policyEMap = DataToolUtils.deserialize(jsonString, HashMap.class);
        HashMap policy1 = (HashMap)policyEMap.get("policy");
        for (Map.Entry entry : policy1.entrySet()) {
            HashMap claimPolicyMap = (HashMap)entry.getValue();
            HashMap disclosureMap = DataToolUtils.deserialize((String)claimPolicyMap.get("fieldsToBeDisclosed"), HashMap.class);
            claimPolicyMap.put("fieldsToBeDisclosed", disclosureMap);
        }
        return DataToolUtils.serialize(policyEMap);
    }

    public Integer getId() {
        return this.id;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getPolicyPublisherWeId() {
        return this.policyPublisherWeId;
    }

    public Map<Integer, ClaimPolicy> getPolicy() {
        return this.policy;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setPolicyPublisherWeId(String policyPublisherWeId) {
        this.policyPublisherWeId = policyPublisherWeId;
    }

    public void setPolicy(Map<Integer, ClaimPolicy> policy) {
        this.policy = policy;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    @Override
    public String toString() {
        return "PresentationPolicyE(id=" + this.getId() + ", orgId=" + this.getOrgId() + ", policyPublisherWeId=" + this.getPolicyPublisherWeId() + ", policy=" + this.getPolicy() + ", extra=" + this.getExtra() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresentationPolicyE)) {
            return false;
        }
        PresentationPolicyE other = (PresentationPolicyE)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$policyPublisherWeId = this.getPolicyPublisherWeId();
        String other$policyPublisherWeId = other.getPolicyPublisherWeId();
        if (this$policyPublisherWeId == null ? other$policyPublisherWeId != null : !this$policyPublisherWeId.equals(other$policyPublisherWeId)) {
            return false;
        }
        Map<Integer, ClaimPolicy> this$policy = this.getPolicy();
        Map<Integer, ClaimPolicy> other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy)) {
            return false;
        }
        Map<String, String> this$extra = this.getExtra();
        Map<String, String> other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PresentationPolicyE;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $policyPublisherWeId = this.getPolicyPublisherWeId();
        result = result * 59 + ($policyPublisherWeId == null ? 43 : $policyPublisherWeId.hashCode());
        Map<Integer, ClaimPolicy> $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        Map<String, String> $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        return result;
    }
}

