/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.protocol.base;

import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.protocol.base.AuthenticationProperty;
import com.webank.weid.protocol.base.PublicKeyProperty;
import com.webank.weid.protocol.base.ServiceProperty;
import com.webank.weid.protocol.inf.JsonSerializer;
import com.webank.weid.util.DataToolUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeIdDocument
implements JsonSerializer {
    private static final Logger logger = LoggerFactory.getLogger(WeIdDocument.class);
    private static final long serialVersionUID = 411522771907189878L;
    private String id;
    private Long created;
    private Long updated;
    private List<PublicKeyProperty> publicKey = new ArrayList<PublicKeyProperty>();
    private List<AuthenticationProperty> authentication = new ArrayList<AuthenticationProperty>();
    private List<ServiceProperty> service = new ArrayList<ServiceProperty>();

    @Override
    public String toJson() {
        return DataToolUtils.addTagFromToJson(DataToolUtils.serialize(this));
    }

    public static WeIdDocument fromJson(String weIdDocumentJson) {
        if (StringUtils.isBlank((CharSequence)weIdDocumentJson)) {
            logger.error("create WeIdDocument with JSON String failed, the WeIdDocument JSON String is null");
            throw new DataTypeCastException("the WeIdDocument JSON String is null.");
        }
        String weIdDocumentString = weIdDocumentJson;
        if (DataToolUtils.isValidFromToJson(weIdDocumentJson)) {
            weIdDocumentString = DataToolUtils.removeTagFromToJson(weIdDocumentJson);
        }
        return DataToolUtils.deserialize(weIdDocumentString, WeIdDocument.class);
    }

    public String getId() {
        return this.id;
    }

    public Long getCreated() {
        return this.created;
    }

    public Long getUpdated() {
        return this.updated;
    }

    public List<PublicKeyProperty> getPublicKey() {
        return this.publicKey;
    }

    public List<AuthenticationProperty> getAuthentication() {
        return this.authentication;
    }

    public List<ServiceProperty> getService() {
        return this.service;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    public void setPublicKey(List<PublicKeyProperty> publicKey) {
        this.publicKey = publicKey;
    }

    public void setAuthentication(List<AuthenticationProperty> authentication) {
        this.authentication = authentication;
    }

    public void setService(List<ServiceProperty> service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeIdDocument)) {
            return false;
        }
        WeIdDocument other = (WeIdDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        List<PublicKeyProperty> this$publicKey = this.getPublicKey();
        List<PublicKeyProperty> other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey)) {
            return false;
        }
        List<AuthenticationProperty> this$authentication = this.getAuthentication();
        List<AuthenticationProperty> other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        List<ServiceProperty> this$service = this.getService();
        List<ServiceProperty> other$service = other.getService();
        return !(this$service == null ? other$service != null : !((Object)this$service).equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeIdDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        List<PublicKeyProperty> $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
        List<AuthenticationProperty> $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        List<ServiceProperty> $service = this.getService();
        result = result * 59 + ($service == null ? 43 : ((Object)$service).hashCode());
        return result;
    }

    public String toString() {
        return "WeIdDocument(id=" + this.getId() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", publicKey=" + this.getPublicKey() + ", authentication=" + this.getAuthentication() + ", service=" + this.getService() + ")";
    }
}

