/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.protocol.response;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.response.TransactionInfo;

public class EngineResultData<T> {
    private T result;
    private Integer errorCode;
    private String errorMessage;
    private TransactionInfo transactionInfo = null;

    public EngineResultData() {
        this.setErrorCode(ErrorCode.SUCCESS);
    }

    public EngineResultData(T result, ErrorCode errorCode) {
        this.result = result;
        if (errorCode != null) {
            this.errorCode = errorCode.getCode();
            this.errorMessage = errorCode.getCodeDesc();
        }
    }

    public EngineResultData(T result, ErrorCode errorCode, TransactionInfo transactionInfo) {
        this.result = result;
        if (errorCode != null) {
            this.errorCode = errorCode.getCode();
            this.errorMessage = errorCode.getCodeDesc();
        }
        if (transactionInfo != null) {
            this.transactionInfo = transactionInfo;
        }
    }

    public void setErrorCode(ErrorCode errorCode) {
        if (errorCode != null) {
            this.errorCode = errorCode.getCode();
            this.errorMessage = errorCode.getCodeDesc();
        }
    }

    public EngineResultData(T result, Integer errorCode, String errorMessage) {
        this.result = result;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public T getResult() {
        return this.result;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setTransactionInfo(TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineResultData)) {
            return false;
        }
        EngineResultData other = (EngineResultData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Integer this$errorCode = this.getErrorCode();
        Integer other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        TransactionInfo this$transactionInfo = this.getTransactionInfo();
        TransactionInfo other$transactionInfo = other.getTransactionInfo();
        return !(this$transactionInfo == null ? other$transactionInfo != null : !((Object)this$transactionInfo).equals(other$transactionInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineResultData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Integer $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        TransactionInfo $transactionInfo = this.getTransactionInfo();
        result = result * 59 + ($transactionInfo == null ? 43 : ((Object)$transactionInfo).hashCode());
        return result;
    }

    public String toString() {
        return "EngineResultData(result=" + this.getResult() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", transactionInfo=" + this.getTransactionInfo() + ")";
    }
}

