/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.rpc.callback;

import com.webank.weid.constant.AmopMsgType;
import com.webank.weid.protocol.amop.AmopRequestBody;
import com.webank.weid.rpc.callback.AmopCallback;
import com.webank.weid.rpc.callback.RegistCallBack;
import com.webank.weid.util.DataToolUtils;
import java.util.HashMap;
import java.util.Map;
import org.fisco.bcos.channel.client.ChannelPushCallback;
import org.fisco.bcos.channel.dto.ChannelPush;
import org.fisco.bcos.channel.dto.ChannelResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnNotifyCallbackV2
extends ChannelPushCallback
implements RegistCallBack {
    private static final Logger logger = LoggerFactory.getLogger(OnNotifyCallbackV2.class);
    private Map<Integer, AmopCallback> amopCallBackMap = new HashMap<Integer, AmopCallback>();
    private AmopCallback defaultAmopCallBack = new AmopCallback();

    @Override
    public void registAmopCallback(Integer msgType, AmopCallback routeCallBack) {
        this.amopCallBackMap.put(msgType, routeCallBack);
    }

    public void onPush(ChannelPush push) {
        logger.info("received ChannelPush v2 msg : " + push.getContent());
        if (0 == this.amopCallBackMap.size()) {
            ChannelResponse response = new ChannelResponse();
            response.setContent("directRouteCallback is null on server side!");
            response.setErrorCode(Integer.valueOf(0));
            push.sendResponse(response);
            return;
        }
        AmopRequestBody amopRequestBody = DataToolUtils.deserialize(push.getContent(), AmopRequestBody.class);
        AmopMsgType msgType = amopRequestBody.getMsgType();
        AmopCallback amopCallBack = this.amopCallBackMap.get(msgType.getValue());
        if (amopCallBack == null) {
            amopCallBack = this.defaultAmopCallBack;
        }
        String messageBody = amopRequestBody.getMsgBody();
        String result = null;
        try {
            result = msgType.callOnPush(amopCallBack, push.getMessageID(), messageBody);
        }
        catch (Exception e) {
            logger.error("callOnPush error, please check the log.", (Throwable)e);
        }
        ChannelResponse response = new ChannelResponse();
        response.setContent(result);
        response.setErrorCode(Integer.valueOf(0));
        push.sendResponse(response);
    }
}

