/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service;

import com.webank.weid.config.ContractConfig;
import com.webank.weid.config.FiscoConfig;
import com.webank.weid.constant.AmopMsgType;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.amop.AmopRequestBody;
import com.webank.weid.protocol.amop.CheckAmopMsgHealthArgs;
import com.webank.weid.protocol.amop.base.AmopBaseMsgArgs;
import com.webank.weid.protocol.response.AmopNotifyMsgResult;
import com.webank.weid.protocol.response.AmopResponse;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.callback.RegistCallBack;
import com.webank.weid.service.fisco.WeServer;
import com.webank.weid.service.impl.base.AmopCommonArgs;
import com.webank.weid.util.DataToolUtils;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseService {
    private static final Logger logger = LoggerFactory.getLogger(BaseService.class);
    protected static FiscoConfig fiscoConfig = new FiscoConfig();
    protected static WeServer<?, ?, ?> weServer;

    public BaseService() {
        if (weServer == null) {
            BaseService.init();
        }
    }

    protected static void init() {
        if (weServer == null) {
            weServer = WeServer.init(fiscoConfig);
        }
    }

    public static Object getWeb3j() {
        if (weServer == null) {
            BaseService.init();
        }
        return weServer.getWeb3j();
    }

    protected static Class<?> getWeb3jClass() {
        if (weServer == null) {
            BaseService.init();
        }
        return weServer.getWeb3jClass();
    }

    protected static int getBlockNumber() throws IOException {
        if (weServer == null) {
            BaseService.init();
        }
        return weServer.getBlockNumber();
    }

    protected static String getSeq() {
        return DataToolUtils.getUuId32();
    }

    protected static ContractConfig buildContractConfig() {
        ContractConfig contractConfig = new ContractConfig();
        contractConfig.setWeIdAddress(fiscoConfig.getWeIdAddress());
        contractConfig.setCptAddress(fiscoConfig.getCptAddress());
        contractConfig.setIssuerAddress(fiscoConfig.getIssuerAddress());
        contractConfig.setEvidenceAddress(fiscoConfig.getEvidenceAddress());
        contractConfig.setSpecificIssuerAddress(fiscoConfig.getSpecificIssuerAddress());
        return contractConfig;
    }

    protected RegistCallBack getPushCallback() {
        if (weServer == null) {
            BaseService.init();
        }
        return weServer.getPushCallback();
    }

    public ResponseData<AmopNotifyMsgResult> checkDirectRouteMsgHealth(String toOrgId, CheckAmopMsgHealthArgs arg) {
        return this.getImpl(fiscoConfig.getCurrentOrgId(), toOrgId, arg, CheckAmopMsgHealthArgs.class, AmopNotifyMsgResult.class, AmopMsgType.TYPE_CHECK_DIRECT_ROUTE_MSG_HEALTH, WeServer.AMOP_REQUEST_TIMEOUT);
    }

    protected <T, F extends AmopBaseMsgArgs> ResponseData<T> getImpl(String fromOrgId, String toOrgId, F arg, Class<F> argsClass, Class<T> resultClass, AmopMsgType msgType, int timeOut) {
        arg.setFromOrgId(fromOrgId);
        arg.setToOrgId(toOrgId);
        String msgBody = DataToolUtils.serialize(arg);
        AmopRequestBody amopRequestBody = new AmopRequestBody();
        amopRequestBody.setMsgType(msgType);
        amopRequestBody.setMsgBody(msgBody);
        String requestBodyStr = DataToolUtils.serialize(amopRequestBody);
        AmopCommonArgs amopCommonArgs = new AmopCommonArgs();
        amopCommonArgs.setToOrgId(toOrgId);
        amopCommonArgs.setMessage(requestBodyStr);
        amopCommonArgs.setMessageId(BaseService.getSeq());
        logger.info("direct route request, seq : {}, body \uff1a{}", (Object)amopCommonArgs.getMessageId(), (Object)requestBodyStr);
        AmopResponse response = weServer.sendChannelMessage(amopCommonArgs, timeOut);
        logger.info("direct route response, seq : {}, errorCode : {}, errorMsg : {}, body : {}", new Object[]{response.getMessageId(), response.getErrorCode(), response.getErrorMessage(), response.getResult()});
        ResponseData<T> responseStruct = new ResponseData<T>();
        if (102 == response.getErrorCode()) {
            responseStruct.setErrorCode(ErrorCode.DIRECT_ROUTE_REQUEST_TIMEOUT);
        } else {
            if (0 != response.getErrorCode()) {
                responseStruct.setErrorCode(ErrorCode.DIRECT_ROUTE_MSG_BASE_ERROR);
                return responseStruct;
            }
            responseStruct.setErrorCode(ErrorCode.getTypeByErrorCode(response.getErrorCode()));
        }
        T msgBodyObj = DataToolUtils.deserialize(response.getResult(), resultClass);
        if (null == msgBodyObj) {
            responseStruct.setErrorCode(ErrorCode.UNKNOW_ERROR);
        }
        responseStruct.setResult(msgBodyObj);
        return responseStruct;
    }

    static {
        if (!fiscoConfig.load()) {
            logger.error("[BaseService] Failed to load Fisco-BCOS blockchain node information.");
        }
        if (StringUtils.isEmpty((CharSequence)fiscoConfig.getCurrentOrgId())) {
            logger.error("[BaseService] the blockchain orgId is blank.");
        }
    }
}

