/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.fisco;

import com.webank.weid.config.FiscoConfig;
import com.webank.weid.constant.AmopMsgType;
import com.webank.weid.protocol.response.AmopResponse;
import com.webank.weid.rpc.callback.RegistCallBack;
import com.webank.weid.service.fisco.v1.WeServerV1;
import com.webank.weid.service.fisco.v2.WeServerV2;
import com.webank.weid.service.impl.base.AmopCommonArgs;
import com.webank.weid.service.impl.callback.KeyManagerCallback;
import com.webank.weid.util.PropertyUtils;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class WeServer<W, C, S> {
    public static final int MAX_AMOP_REQUEST_TIMEOUT = 50000;
    public static final int AMOP_REQUEST_TIMEOUT = Integer.valueOf(PropertyUtils.getProperty("amop.request.timeout", "5000"));
    private static final Logger logger = LoggerFactory.getLogger(WeServer.class);
    private static WeServer<?, ?, ?> weServer;
    protected FiscoConfig fiscoConfig;
    protected RegistCallBack pushCallBack;

    protected WeServer(FiscoConfig fiscoConfig, RegistCallBack pushCallBack) {
        this.fiscoConfig = fiscoConfig;
        this.pushCallBack = pushCallBack;
        this.registDefaultCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized <W, C, S> WeServer<W, C, S> init(FiscoConfig fiscoConfig) {
        if (weServer != null) return weServer;
        Class<WeServer> clazz = WeServer.class;
        synchronized (WeServer.class) {
            if (weServer != null) return weServer;
            weServer = fiscoConfig.getVersion().startsWith("1") ? new WeServerV1(fiscoConfig) : new WeServerV2(fiscoConfig);
            weServer.initWeb3j();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return weServer;
        }
    }

    private void registDefaultCallback() {
        this.pushCallBack.registAmopCallback(AmopMsgType.GET_ENCRYPT_KEY.getValue(), new KeyManagerCallback());
    }

    public RegistCallBack getPushCallback() {
        return this.pushCallBack;
    }

    protected ThreadPoolTaskExecutor initializePool() {
        ThreadPoolTaskExecutor pool = new ThreadPoolTaskExecutor();
        pool.setBeanName("web3sdk");
        pool.setCorePoolSize(Integer.valueOf(this.fiscoConfig.getWeb3sdkCorePoolSize()).intValue());
        pool.setMaxPoolSize(Integer.valueOf(this.fiscoConfig.getWeb3sdkMaxPoolSize()).intValue());
        pool.setQueueCapacity(Integer.valueOf(this.fiscoConfig.getWeb3sdkQueueSize()).intValue());
        pool.setKeepAliveSeconds(Integer.valueOf(this.fiscoConfig.getWeb3sdkKeepAliveSeconds()).intValue());
        pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        pool.initialize();
        return pool;
    }

    protected int getTimeOut(int timeOut) {
        if (timeOut > 50000 || timeOut < 0) {
            logger.error("invalid timeOut : {}", (Object)timeOut);
            return 50000;
        }
        return timeOut;
    }

    public abstract W getWeb3j();

    public abstract Class<?> getWeb3jClass();

    public abstract S getService();

    public abstract C getCredentials();

    public abstract C createCredentials(String var1);

    protected abstract void initWeb3j();

    public abstract AmopResponse sendChannelMessage(AmopCommonArgs var1, int var2);

    public abstract int getBlockNumber() throws IOException;
}

