/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl;

import com.webank.weid.constant.AmopMsgType;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.amop.GetEncryptKeyArgs;
import com.webank.weid.protocol.amop.GetPolicyAndChallengeArgs;
import com.webank.weid.protocol.base.PolicyAndChallenge;
import com.webank.weid.protocol.response.AmopResponse;
import com.webank.weid.protocol.response.GetEncryptKeyResponse;
import com.webank.weid.protocol.response.GetPolicyAndChallengeResponse;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.AmopService;
import com.webank.weid.rpc.callback.AmopCallback;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.fisco.WeServer;
import com.webank.weid.service.impl.base.AmopCommonArgs;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmopServiceImpl
extends BaseService
implements AmopService {
    private static final Logger logger = LoggerFactory.getLogger(AmopServiceImpl.class);

    @Override
    public ResponseData<PolicyAndChallenge> getPolicyAndChallenge(String targetOrgId, Integer policyId, String targetUserWeId) {
        try {
            if (StringUtils.isBlank((CharSequence)fiscoConfig.getCurrentOrgId())) {
                logger.error("the orgId is null, policyId = {}", (Object)policyId);
                return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
            }
            GetPolicyAndChallengeArgs args = new GetPolicyAndChallengeArgs();
            args.setFromOrgId(fiscoConfig.getCurrentOrgId());
            args.setToOrgId(targetOrgId);
            args.setPolicyId(String.valueOf(policyId));
            args.setMessageId(BaseService.getSeq());
            args.setTargetUserWeId(targetUserWeId);
            ResponseData<GetPolicyAndChallengeResponse> retResponse = this.getPolicyAndChallenge(targetOrgId, args);
            if (retResponse.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                logger.error("AMOP response fail, policyId={}, errorCode={}, errorMessage={}", new Object[]{policyId, retResponse.getErrorCode(), retResponse.getErrorMessage()});
                return new ResponseData<Object>(null, ErrorCode.getTypeByErrorCode(retResponse.getErrorCode()));
            }
            GetPolicyAndChallengeResponse result = retResponse.getResult();
            ErrorCode errorCode = ErrorCode.getTypeByErrorCode(result.getErrorCode());
            return new ResponseData<PolicyAndChallenge>(result.getPolicyAndChallenge(), errorCode);
        }
        catch (Exception e) {
            logger.error("getPresentationPolicy failed due to system error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    private ResponseData<GetPolicyAndChallengeResponse> getPolicyAndChallenge(String toOrgId, GetPolicyAndChallengeArgs args) {
        return this.getImpl(fiscoConfig.getCurrentOrgId(), toOrgId, args, GetPolicyAndChallengeArgs.class, GetPolicyAndChallengeResponse.class, AmopMsgType.GET_POLICY_AND_CHALLENGE, WeServer.AMOP_REQUEST_TIMEOUT);
    }

    @Override
    public ResponseData<AmopResponse> request(String toOrgId, AmopCommonArgs args) {
        return this.getImpl(fiscoConfig.getCurrentOrgId(), toOrgId, args, AmopCommonArgs.class, AmopResponse.class, AmopMsgType.TYPE_TRANSPORTATION, WeServer.AMOP_REQUEST_TIMEOUT);
    }

    @Override
    public ResponseData<GetEncryptKeyResponse> getEncryptKey(String toOrgId, GetEncryptKeyArgs args) {
        return this.getImpl(fiscoConfig.getCurrentOrgId(), toOrgId, args, GetEncryptKeyArgs.class, GetEncryptKeyResponse.class, AmopMsgType.GET_ENCRYPT_KEY, WeServer.AMOP_REQUEST_TIMEOUT);
    }

    @Override
    public void registerCallback(Integer directRouteMsgType, AmopCallback directRouteCallback) {
        super.getPushCallback().registAmopCallback(directRouteMsgType, directRouteCallback);
    }
}

