/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.protocol.base.AuthorityIssuer;
import com.webank.weid.protocol.base.WeIdAuthentication;
import com.webank.weid.protocol.request.RegisterAuthorityIssuerArgs;
import com.webank.weid.protocol.request.RemoveAuthorityIssuerArgs;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.AuthorityIssuerService;
import com.webank.weid.rpc.WeIdService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.WeIdServiceImpl;
import com.webank.weid.service.impl.engine.AuthorityIssuerServiceEngine;
import com.webank.weid.service.impl.engine.EngineFactory;
import com.webank.weid.util.WeIdUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityIssuerServiceImpl
extends BaseService
implements AuthorityIssuerService {
    private static final Logger logger = LoggerFactory.getLogger(AuthorityIssuerServiceImpl.class);
    private AuthorityIssuerServiceEngine engine = EngineFactory.createAuthorityIssuerServiceEngine();
    private WeIdService weIdService = new WeIdServiceImpl();

    @Override
    public ResponseData<Boolean> registerAuthorityIssuer(RegisterAuthorityIssuerArgs args) {
        ErrorCode innerResponseData = this.checkRegisterAuthorityIssuerArgs(args);
        if (ErrorCode.SUCCESS.getCode() != innerResponseData.getCode()) {
            return new ResponseData<Boolean>(false, innerResponseData);
        }
        try {
            return this.engine.addAuthorityIssuer(args);
        }
        catch (Exception e) {
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> removeAuthorityIssuer(RemoveAuthorityIssuerArgs args) {
        ErrorCode innerResponseData = this.checkRemoveAuthorityIssuerArgs(args);
        if (ErrorCode.SUCCESS.getCode() != innerResponseData.getCode()) {
            return new ResponseData<Boolean>(false, innerResponseData);
        }
        try {
            return this.engine.removeAuthorityIssuer(args);
        }
        catch (Exception e) {
            logger.error("remove authority issuer failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> isAuthorityIssuer(String weId) {
        if (!WeIdUtils.isWeIdValid(weId)) {
            return new ResponseData<Boolean>(false, ErrorCode.WEID_INVALID);
        }
        String addr = WeIdUtils.convertWeIdToAddress(weId);
        try {
            return this.engine.isAuthorityIssuer(addr);
        }
        catch (Exception e) {
            logger.error("check authority issuer id failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<AuthorityIssuer> queryAuthorityIssuerInfo(String weId) {
        if (!WeIdUtils.isWeIdValid(weId)) {
            return new ResponseData<Object>(null, ErrorCode.WEID_INVALID);
        }
        try {
            return this.engine.getAuthorityIssuerInfoNonAccValue(weId);
        }
        catch (Exception e) {
            logger.error("query authority issuer failed.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<List<AuthorityIssuer>> getAllAuthorityIssuerList(Integer index, Integer num) {
        ErrorCode errorCode = this.isStartEndPosValid(index, num);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return new ResponseData<Object>(null, errorCode);
        }
        try {
            List<String> addrList = this.engine.getAuthorityIssuerAddressList(index, num);
            ArrayList<AuthorityIssuer> authorityIssuerList = new ArrayList<AuthorityIssuer>();
            for (String address : addrList) {
                String weId = WeIdUtils.convertAddressToWeId(address);
                ResponseData<AuthorityIssuer> innerResponseData = this.queryAuthorityIssuerInfo(weId);
                if (innerResponseData.getResult() == null) continue;
                authorityIssuerList.add(innerResponseData.getResult());
            }
            return new ResponseData<List<AuthorityIssuer>>(authorityIssuerList, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("query authority issuer list failed.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> registerIssuerType(WeIdAuthentication callerAuth, String issuerType) {
        ErrorCode innerCode = this.isIssuerTypeValid(issuerType);
        if (innerCode != ErrorCode.SUCCESS) {
            return new ResponseData<Boolean>(false, innerCode);
        }
        innerCode = this.isCallerAuthValid(callerAuth);
        if (innerCode != ErrorCode.SUCCESS) {
            return new ResponseData<Boolean>(false, innerCode);
        }
        try {
            return this.engine.registerIssuerType(issuerType, callerAuth.getWeIdPrivateKey().getPrivateKey());
        }
        catch (Exception e) {
            logger.error("register issuer type failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> addIssuerIntoIssuerType(WeIdAuthentication callerAuth, String issuerType, String targetIssuerWeId) {
        ErrorCode innerCode = this.isSpecificTypeIssuerArgsValid(callerAuth, issuerType, targetIssuerWeId);
        if (innerCode != ErrorCode.SUCCESS) {
            return new ResponseData<Boolean>(false, innerCode);
        }
        try {
            String issuerAddress = WeIdUtils.convertWeIdToAddress(targetIssuerWeId);
            return this.engine.addIssuer(issuerType, issuerAddress, callerAuth.getWeIdPrivateKey().getPrivateKey());
        }
        catch (Exception e) {
            logger.error("add issuer into type failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> removeIssuerFromIssuerType(WeIdAuthentication callerAuth, String issuerType, String targetIssuerWeId) {
        ErrorCode innerCode = this.isSpecificTypeIssuerArgsValid(callerAuth, issuerType, targetIssuerWeId);
        if (innerCode != ErrorCode.SUCCESS) {
            return new ResponseData<Boolean>(false, innerCode);
        }
        try {
            String issuerAddress = WeIdUtils.convertWeIdToAddress(targetIssuerWeId);
            return this.engine.removeIssuer(issuerType, issuerAddress, callerAuth.getWeIdPrivateKey().getPrivateKey());
        }
        catch (Exception e) {
            logger.error("remove issuer from type failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> isSpecificTypeIssuer(String issuerType, String targetIssuerWeId) {
        ErrorCode errorCode = this.isIssuerTypeValid(issuerType);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return new ResponseData<Boolean>(false, errorCode);
        }
        if (!this.weIdService.isWeIdExist(targetIssuerWeId).getResult().booleanValue()) {
            return new ResponseData<Boolean>(false, ErrorCode.WEID_DOES_NOT_EXIST);
        }
        try {
            String address = WeIdUtils.convertWeIdToAddress(targetIssuerWeId);
            return this.engine.isSpecificTypeIssuer(issuerType, address);
        }
        catch (Exception e) {
            logger.error("check issuer type failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<List<String>> getAllSpecificTypeIssuerList(String issuerType, Integer index, Integer num) {
        ErrorCode errorCode = this.isIssuerTypeValid(issuerType);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return new ResponseData<Object>(null, errorCode);
        }
        errorCode = this.isStartEndPosValid(index, num);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return new ResponseData<Object>(null, errorCode);
        }
        try {
            return this.engine.getSpecificTypeIssuerList(issuerType, index, num);
        }
        catch (Exception e) {
            logger.error("get all specific issuers failed.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    private ErrorCode isStartEndPosValid(Integer index, Integer num) {
        if (index == null || index < 0 || num == null || num <= 0 || num > WeIdConstant.MAX_AUTHORITY_ISSUER_LIST_SIZE) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode isSpecificTypeIssuerArgsValid(WeIdAuthentication callerAuth, String issuerType, String targetIssuerWeId) {
        if (!WeIdUtils.isWeIdValid(targetIssuerWeId)) {
            return ErrorCode.WEID_INVALID;
        }
        if (!this.weIdService.isWeIdExist(targetIssuerWeId).getResult().booleanValue()) {
            return ErrorCode.WEID_DOES_NOT_EXIST;
        }
        ErrorCode errorCode = this.isCallerAuthValid(callerAuth);
        if (errorCode.getCode() == ErrorCode.SUCCESS.getCode()) {
            return this.isIssuerTypeValid(issuerType);
        }
        return errorCode;
    }

    private ErrorCode isCallerAuthValid(WeIdAuthentication callerAuth) {
        if (callerAuth == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (!WeIdUtils.isWeIdValid(callerAuth.getWeId())) {
            return ErrorCode.WEID_INVALID;
        }
        if (!this.weIdService.isWeIdExist(callerAuth.getWeId()).getResult().booleanValue()) {
            return ErrorCode.WEID_DOES_NOT_EXIST;
        }
        if (callerAuth.getWeIdPrivateKey() == null || StringUtils.isEmpty((CharSequence)callerAuth.getWeIdPrivateKey().getPrivateKey())) {
            return ErrorCode.AUTHORITY_ISSUER_PRIVATE_KEY_ILLEGAL;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode isIssuerTypeValid(String issuerType) {
        if (StringUtils.isEmpty((CharSequence)issuerType)) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (issuerType.length() > WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH) {
            return ErrorCode.SPECIFIC_ISSUER_TYPE_ILLEGAL;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode checkRegisterAuthorityIssuerArgs(RegisterAuthorityIssuerArgs args) {
        if (args == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        ErrorCode errorCode = this.checkAuthorityIssuerArgsValidity(args.getAuthorityIssuer());
        if (ErrorCode.SUCCESS.getCode() != errorCode.getCode()) {
            logger.error("register authority issuer format error!");
            return errorCode;
        }
        if (args.getWeIdPrivateKey() == null || StringUtils.isEmpty((CharSequence)args.getWeIdPrivateKey().getPrivateKey())) {
            return ErrorCode.AUTHORITY_ISSUER_PRIVATE_KEY_ILLEGAL;
        }
        ResponseData<Boolean> innerResponseData = this.weIdService.isWeIdExist(args.getAuthorityIssuer().getWeId());
        if (!innerResponseData.getResult().booleanValue()) {
            return ErrorCode.WEID_INVALID;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode checkRemoveAuthorityIssuerArgs(RemoveAuthorityIssuerArgs args) {
        if (args == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (!WeIdUtils.isWeIdValid(args.getWeId())) {
            return ErrorCode.WEID_INVALID;
        }
        if (args.getWeIdPrivateKey() == null || StringUtils.isEmpty((CharSequence)args.getWeIdPrivateKey().getPrivateKey())) {
            return ErrorCode.AUTHORITY_ISSUER_PRIVATE_KEY_ILLEGAL;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode checkAuthorityIssuerArgsValidity(AuthorityIssuer args) {
        if (args == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (!WeIdUtils.isWeIdValid(args.getWeId())) {
            return ErrorCode.WEID_INVALID;
        }
        String name = args.getName();
        if (!this.isValidAuthorityIssuerName(name)) {
            return ErrorCode.AUTHORITY_ISSUER_NAME_ILLEGAL;
        }
        String accValue = args.getAccValue();
        try {
            BigInteger accValueBigInteger = new BigInteger(accValue);
            logger.info(args.getWeId() + " accValue is: " + accValueBigInteger.longValue());
            if (accValueBigInteger.compareTo(BigInteger.ZERO) < 0) {
                return ErrorCode.AUTHORITY_ISSUER_ACCVALUE_ILLEAGAL;
            }
        }
        catch (Exception e) {
            return ErrorCode.AUTHORITY_ISSUER_ACCVALUE_ILLEAGAL;
        }
        return ErrorCode.SUCCESS;
    }

    private boolean isValidAuthorityIssuerName(String name) {
        return !StringUtils.isEmpty((CharSequence)name) && name.getBytes(StandardCharsets.UTF_8).length < WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH && !StringUtils.isWhitespace((CharSequence)name);
    }
}

