/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.base.Cpt;
import com.webank.weid.protocol.base.CptBaseInfo;
import com.webank.weid.protocol.base.WeIdAuthentication;
import com.webank.weid.protocol.base.WeIdPrivateKey;
import com.webank.weid.protocol.request.CptMapArgs;
import com.webank.weid.protocol.request.CptStringArgs;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.RsvSignature;
import com.webank.weid.rpc.CptService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.engine.CptServiceEngine;
import com.webank.weid.service.impl.engine.EngineFactory;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.WeIdUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bcos.web3j.crypto.Sign;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CptServiceImpl
extends BaseService
implements CptService {
    private static final Logger logger = LoggerFactory.getLogger(CptServiceImpl.class);
    private CptServiceEngine cptServiceEngine = EngineFactory.createCptServiceEngine();

    @Override
    public ResponseData<CptBaseInfo> registerCpt(CptStringArgs args, Integer cptId) {
        if (args == null || cptId == null || cptId <= 0) {
            logger.error("[registerCpt1] input argument is illegal");
            return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
        }
        try {
            CptMapArgs cptMapArgs = new CptMapArgs();
            cptMapArgs.setWeIdAuthentication(args.getWeIdAuthentication());
            Map cptJsonSchemaMap = DataToolUtils.deserialize(args.getCptJsonSchema(), HashMap.class);
            cptMapArgs.setCptJsonSchema(cptJsonSchemaMap);
            return this.registerCpt(cptMapArgs, cptId);
        }
        catch (Exception e) {
            logger.error("[registerCpt1] register cpt failed due to unknown error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> registerCpt(CptStringArgs args) {
        try {
            if (args == null) {
                logger.error("[registerCpt1]input CptStringArgs is null");
                return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
            }
            CptMapArgs cptMapArgs = new CptMapArgs();
            cptMapArgs.setWeIdAuthentication(args.getWeIdAuthentication());
            Map cptJsonSchemaMap = DataToolUtils.deserialize(args.getCptJsonSchema(), HashMap.class);
            cptMapArgs.setCptJsonSchema(cptJsonSchemaMap);
            return this.registerCpt(cptMapArgs);
        }
        catch (Exception e) {
            logger.error("[registerCpt1] register cpt failed due to unknown error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> registerCpt(CptMapArgs args, Integer cptId) {
        if (args == null || cptId == null || cptId <= 0) {
            logger.error("[registerCpt] input argument is illegal");
            return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
        }
        try {
            ErrorCode errorCode = this.validateCptArgs(args.getWeIdAuthentication(), args.getCptJsonSchema());
            if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
                return new ResponseData<Object>(null, errorCode);
            }
            String weId = args.getWeIdAuthentication().getWeId();
            WeIdPrivateKey weIdPrivateKey = args.getWeIdAuthentication().getWeIdPrivateKey();
            String cptJsonSchemaNew = this.cptSchemaToString(args.getCptJsonSchema());
            RsvSignature rsvSignature = this.sign(weId, cptJsonSchemaNew, weIdPrivateKey);
            String address = WeIdUtils.convertWeIdToAddress(weId);
            return this.cptServiceEngine.registerCpt(cptId, address, cptJsonSchemaNew, rsvSignature, weIdPrivateKey.getPrivateKey());
        }
        catch (Exception e) {
            logger.error("[registerCpt] register cpt failed due to unknown error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> registerCpt(CptMapArgs args) {
        try {
            if (args == null) {
                logger.error("[registerCpt]input CptMapArgs is null");
                return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
            }
            ErrorCode validateResult = this.validateCptArgs(args.getWeIdAuthentication(), args.getCptJsonSchema());
            if (validateResult.getCode() != ErrorCode.SUCCESS.getCode()) {
                return new ResponseData<Object>(null, validateResult);
            }
            String weId = args.getWeIdAuthentication().getWeId();
            WeIdPrivateKey weIdPrivateKey = args.getWeIdAuthentication().getWeIdPrivateKey();
            String cptJsonSchemaNew = this.cptSchemaToString(args.getCptJsonSchema());
            RsvSignature rsvSignature = this.sign(weId, cptJsonSchemaNew, weIdPrivateKey);
            String address = WeIdUtils.convertWeIdToAddress(weId);
            return this.cptServiceEngine.registerCpt(address, cptJsonSchemaNew, rsvSignature, weIdPrivateKey.getPrivateKey());
        }
        catch (Exception e) {
            logger.error("[registerCpt] register cpt failed due to unknown error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<Cpt> queryCpt(Integer cptId) {
        try {
            if (cptId == null || cptId < 0) {
                return new ResponseData<Object>(null, ErrorCode.CPT_ID_ILLEGAL);
            }
            return this.cptServiceEngine.queryCpt(cptId);
        }
        catch (Exception e) {
            logger.error("[updateCpt] query cpt failed due to unknown error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> updateCpt(CptStringArgs args, Integer cptId) {
        try {
            if (args == null) {
                logger.error("[updateCpt1]input UpdateCptArgs is null");
                return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
            }
            CptMapArgs cptMapArgs = new CptMapArgs();
            cptMapArgs.setWeIdAuthentication(args.getWeIdAuthentication());
            cptMapArgs.setCptJsonSchema(DataToolUtils.deserialize(args.getCptJsonSchema(), HashMap.class));
            return this.updateCpt(cptMapArgs, cptId);
        }
        catch (Exception e) {
            logger.error("[updateCpt1] update cpt failed due to unkown error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> updateCpt(CptMapArgs args, Integer cptId) {
        try {
            if (args == null) {
                logger.error("[updateCpt]input UpdateCptArgs is null");
                return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
            }
            if (cptId == null || cptId < 0) {
                logger.error("[updateCpt]input cptId illegal");
                return new ResponseData<Object>(null, ErrorCode.CPT_ID_ILLEGAL);
            }
            ErrorCode errorCode = this.validateCptArgs(args.getWeIdAuthentication(), args.getCptJsonSchema());
            if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
                return new ResponseData<Object>(null, errorCode);
            }
            String weId = args.getWeIdAuthentication().getWeId();
            WeIdPrivateKey weIdPrivateKey = args.getWeIdAuthentication().getWeIdPrivateKey();
            String cptJsonSchemaNew = this.cptSchemaToString(args.getCptJsonSchema());
            RsvSignature rsvSignature = this.sign(weId, cptJsonSchemaNew, weIdPrivateKey);
            String address = WeIdUtils.convertWeIdToAddress(weId);
            return this.cptServiceEngine.updateCpt(cptId, address, cptJsonSchemaNew, rsvSignature, weIdPrivateKey.getPrivateKey());
        }
        catch (Exception e) {
            logger.error("[updateCpt] update cpt failed due to unkown error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    private RsvSignature sign(String cptPublisher, String jsonSchema, WeIdPrivateKey cptPublisherPrivateKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(cptPublisher);
        sb.append("|");
        sb.append(jsonSchema);
        Sign.SignatureData signatureData = DataToolUtils.signMessage(sb.toString(), cptPublisherPrivateKey.getPrivateKey());
        return DataToolUtils.convertSignatureDataToRsv(signatureData);
    }

    private ErrorCode validateCptArgs(WeIdAuthentication weIdAuthentication, Map<String, Object> cptJsonSchemaMap) throws Exception {
        if (weIdAuthentication == null) {
            logger.error("Input cpt weIdAuthentication is invalid.");
            return ErrorCode.WEID_AUTHORITY_INVALID;
        }
        String weId = weIdAuthentication.getWeId();
        if (!WeIdUtils.isWeIdValid(weId)) {
            logger.error("Input cpt publisher : {} is invalid.", (Object)weId);
            return ErrorCode.WEID_INVALID;
        }
        ErrorCode errorCode = this.validateCptJsonSchemaMap(cptJsonSchemaMap);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return errorCode;
        }
        String cptJsonSchema = DataToolUtils.serialize(cptJsonSchemaMap);
        if (!DataToolUtils.isCptJsonSchemaValid(cptJsonSchema)) {
            logger.error("Input cpt json schema : {} is invalid.", cptJsonSchemaMap);
            return ErrorCode.CPT_JSON_SCHEMA_INVALID;
        }
        WeIdPrivateKey weIdPrivateKey = weIdAuthentication.getWeIdPrivateKey();
        if (weIdPrivateKey == null || StringUtils.isEmpty((CharSequence)weIdPrivateKey.getPrivateKey())) {
            logger.error("Input cpt publisher private key : {} is in valid.", (Object)weIdPrivateKey);
            return ErrorCode.WEID_PRIVATEKEY_INVALID;
        }
        if (!WeIdUtils.validatePrivateKeyWeIdMatches(weIdPrivateKey, weId)) {
            return ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode validateCptJsonSchemaMap(Map<String, Object> cptJsonSchemaMap) throws Exception {
        if (cptJsonSchemaMap == null || cptJsonSchemaMap.isEmpty()) {
            logger.error("Input cpt json schema is invalid.");
            return ErrorCode.CPT_JSON_SCHEMA_INVALID;
        }
        String cptJsonSchema = DataToolUtils.serialize(cptJsonSchemaMap);
        if (!DataToolUtils.isCptJsonSchemaValid(cptJsonSchema)) {
            logger.error("Input cpt json schema : {} is invalid.", cptJsonSchemaMap);
            return ErrorCode.CPT_JSON_SCHEMA_INVALID;
        }
        return ErrorCode.SUCCESS;
    }

    private String cptSchemaToString(Map<String, Object> cptJsonSchema) throws Exception {
        HashMap<String, Object> cptJsonSchemaNew = new HashMap<String, Object>();
        cptJsonSchemaNew.put("$schema", "http://json-schema.org/draft-04/schema#");
        cptJsonSchemaNew.put("type", "object");
        cptJsonSchemaNew.putAll(cptJsonSchema);
        return DataToolUtils.serialize(cptJsonSchemaNew);
    }
}

