/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl;

import com.webank.weid.constant.CredentialConstant;
import com.webank.weid.constant.CredentialFieldDisclosureValue;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.base.Challenge;
import com.webank.weid.protocol.base.ClaimPolicy;
import com.webank.weid.protocol.base.Cpt;
import com.webank.weid.protocol.base.CredentialPojo;
import com.webank.weid.protocol.base.PresentationE;
import com.webank.weid.protocol.base.PresentationPolicyE;
import com.webank.weid.protocol.base.WeIdAuthentication;
import com.webank.weid.protocol.base.WeIdDocument;
import com.webank.weid.protocol.base.WeIdPublicKey;
import com.webank.weid.protocol.request.CreateCredentialPojoArgs;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.CptService;
import com.webank.weid.rpc.CredentialPojoService;
import com.webank.weid.rpc.WeIdService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.CptServiceImpl;
import com.webank.weid.service.impl.WeIdServiceImpl;
import com.webank.weid.util.CredentialPojoUtils;
import com.webank.weid.util.CredentialUtils;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.DateUtils;
import com.webank.weid.util.WeIdUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialPojoServiceImpl
extends BaseService
implements CredentialPojoService {
    private static final Logger logger = LoggerFactory.getLogger(CredentialPojoServiceImpl.class);
    private static WeIdService weIdService = new WeIdServiceImpl();
    private static CptService cptService = new CptServiceImpl();
    private static String NOT_DISCLOSED = CredentialFieldDisclosureValue.NOT_DISCLOSED.getStatus().toString();
    private static String DISCLOSED = CredentialFieldDisclosureValue.DISCLOSED.getStatus().toString();
    private static String EXISTED = CredentialFieldDisclosureValue.EXISTED.getStatus().toString();

    public static void generateSalt(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                CredentialPojoServiceImpl.generateSalt((HashMap)value);
                continue;
            }
            if (value instanceof List) {
                boolean isMapOrList = CredentialPojoServiceImpl.generateSaltFromList((ArrayList)value);
                if (isMapOrList) continue;
                CredentialPojoServiceImpl.addSalt(entry);
                continue;
            }
            CredentialPojoServiceImpl.addSalt(entry);
        }
    }

    private static void addSalt(Map.Entry<String, Object> entry) {
        String salt = DataToolUtils.getRandomSalt();
        entry.setValue(salt);
    }

    private static boolean generateSaltFromList(List<Object> objList) {
        List<Object> list = objList;
        for (Object obj : list) {
            if (obj instanceof Map) {
                CredentialPojoServiceImpl.generateSalt((HashMap)obj);
                continue;
            }
            if (obj instanceof List) {
                boolean result = CredentialPojoServiceImpl.generateSaltFromList((ArrayList)obj);
                if (result) continue;
                return result;
            }
            return false;
        }
        return true;
    }

    private static boolean validCredentialMapArgs(Map<String, Object> claim, Map<String, Object> salt, Map<String, Object> disclosureMap) {
        if (claim == null || salt == null || disclosureMap == null) {
            return false;
        }
        Set<String> claimKeys = claim.keySet();
        Set<String> saltKeys = salt.keySet();
        Set<String> disclosureKeys = disclosureMap.keySet();
        if (claimKeys.size() != saltKeys.size() || saltKeys.size() != disclosureKeys.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : disclosureMap.entrySet()) {
            String k = entry.getKey();
            Object v = entry.getValue();
            Object saltV = salt.get(k);
            Object claimV = claim.get(k);
            if (!salt.containsKey(k) || !disclosureMap.containsKey(k)) {
                return false;
            }
            if (!(v instanceof Map ? !CredentialPojoServiceImpl.validCredentialMapArgs((HashMap)claimV, (HashMap)saltV, (HashMap)v) : v instanceof List && !CredentialPojoServiceImpl.validCredentialListArgs((List<Object>)((ArrayList)claimV), (List<Object>)((ArrayList)saltV), (ArrayList)v))) continue;
            return false;
        }
        return true;
    }

    private static boolean validCredentialListArgs(List<Object> claimList, List<Object> saltList, List<Object> disclosureList) {
        if (claimList == null || saltList == null || disclosureList == null) {
            return false;
        }
        if (claimList.size() != saltList.size()) {
            return false;
        }
        for (int i = 0; i < disclosureList.size(); ++i) {
            boolean result;
            Object disclosureObj = disclosureList.get(i);
            Object claimObj = claimList.get(i);
            Object saltObj = saltList.get(i);
            if (!(disclosureObj instanceof Map ? !(result = CredentialPojoServiceImpl.validCredentialListArgs(claimList, saltList, (HashMap)disclosureObj)) : disclosureObj instanceof List && !(result = CredentialPojoServiceImpl.validCredentialListArgs((List<Object>)((ArrayList)claimObj), (List<Object>)((ArrayList)saltObj), (ArrayList)disclosureObj)))) continue;
            return result;
        }
        return true;
    }

    private static boolean validCredentialListArgs(List<Object> claimList, List<Object> saltList, Map<String, Object> disclosure) {
        if (claimList == null || saltList == null || saltList.size() != claimList.size()) {
            return false;
        }
        for (int i = 0; i < claimList.size(); ++i) {
            Object salt;
            Object claim = claimList.get(i);
            boolean result = CredentialPojoServiceImpl.validCredentialMapArgs((HashMap)claim, (HashMap)(salt = saltList.get(i)), disclosure);
            if (result) continue;
            return result;
        }
        return true;
    }

    private static void addSelectSalt(Map<String, Object> disclosureMap, Map<String, Object> saltMap, Map<String, Object> claim) {
        for (Map.Entry<String, Object> entry : disclosureMap.entrySet()) {
            String disclosureKey = entry.getKey();
            Object value = entry.getValue();
            Object saltV = saltMap.get(disclosureKey);
            Object claimV = claim.get(disclosureKey);
            if (value == null) {
                throw new WeIdBaseException(ErrorCode.CREDENTIAL_POLICY_DISCLOSUREVALUE_ILLEGAL);
            }
            if (value instanceof Map) {
                CredentialPojoServiceImpl.addSelectSalt((HashMap)value, (HashMap)saltV, (HashMap)claimV);
                continue;
            }
            if (value instanceof List) {
                CredentialPojoServiceImpl.addSaltForList((ArrayList)value, (List<Object>)((ArrayList)saltV), (List<Object>)((ArrayList)claimV));
                continue;
            }
            CredentialPojoServiceImpl.addHashToClaim(saltMap, claim, disclosureKey, value, saltV, claimV);
        }
    }

    private static void addHashToClaim(Map<String, Object> saltMap, Map<String, Object> claim, String disclosureKey, Object value, Object saltV, Object claimV) {
        if (((Integer)value).equals(Integer.parseInt(NOT_DISCLOSED))) {
            saltMap.put(disclosureKey, NOT_DISCLOSED);
            String hash = CredentialPojoUtils.getFieldSaltHash(String.valueOf(claimV), String.valueOf(saltV));
            claim.put(disclosureKey, hash);
        }
    }

    private static void addSaltForList(List<Object> disclosures, List<Object> salt, List<Object> claim) {
        for (int i = 0; claim != null && i < disclosures.size(); ++i) {
            Object disclosureObj = disclosures.get(i);
            Object claimObj = claim.get(i);
            Object saltObj = salt.get(i);
            if (disclosureObj instanceof Map) {
                CredentialPojoServiceImpl.addSaltForList((HashMap)disclosureObj, salt, claim);
                continue;
            }
            if (!(disclosureObj instanceof List)) continue;
            CredentialPojoServiceImpl.addSaltForList((ArrayList)disclosureObj, (List<Object>)((ArrayList)saltObj), (List<Object>)((ArrayList)claimObj));
        }
    }

    private static void addSaltForList(Map<String, Object> disclosures, List<Object> salt, List<Object> claim) {
        for (int i = 0; claim != null && i < claim.size(); ++i) {
            Object claimObj = claim.get(i);
            Object saltObj = salt.get(i);
            CredentialPojoServiceImpl.addSelectSalt(disclosures, (HashMap)saltObj, (HashMap)claimObj);
        }
    }

    private static ErrorCode verifyContent(CredentialPojo credential, String publicKey) {
        try {
            return CredentialPojoServiceImpl.verifyContent(credential, publicKey, null);
        }
        catch (WeIdBaseException ex) {
            logger.error("[verifyContent] verify credential has exception.", (Throwable)ex);
            return ex.getErrorCode();
        }
    }

    private static ErrorCode verifyContent(CredentialPojo credential, String publicKey, ClaimPolicy claimPolicy) {
        boolean result;
        ErrorCode checkResp = CredentialPojoUtils.isCredentialPojoValid(credential);
        if (ErrorCode.SUCCESS.getCode() != checkResp.getCode()) {
            return checkResp;
        }
        ErrorCode errorCode = CredentialPojoServiceImpl.verifyCptFormat(credential.getCptId(), credential.getClaim(), CredentialPojoServiceImpl.isSelectivelyDisclosed(credential.getSalt()));
        if (ErrorCode.SUCCESS.getCode() != errorCode.getCode()) {
            return errorCode;
        }
        Map<String, Object> salt = credential.getSalt();
        String rawData = CredentialPojoUtils.getCredentialThumbprintWithoutSig(credential, salt, null);
        String issuerWeid = credential.getIssuer();
        if (StringUtils.isEmpty((CharSequence)publicKey)) {
            ResponseData<WeIdDocument> innerResponseData = weIdService.getWeIdDocument(issuerWeid);
            if (innerResponseData.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                logger.error("Error occurred when fetching WeIdentity DID document for: {}, msg: {}", (Object)issuerWeid, (Object)innerResponseData.getErrorMessage());
                return ErrorCode.getTypeByErrorCode(innerResponseData.getErrorCode());
            }
            WeIdDocument weIdDocument = innerResponseData.getResult();
            return DataToolUtils.verifySignatureFromWeId(rawData, credential.getSignature(), weIdDocument);
        }
        try {
            result = DataToolUtils.verifySignature(rawData, credential.getSignature(), new BigInteger(publicKey));
        }
        catch (Exception e) {
            logger.error("[verifyContent] verify signature fail.", (Throwable)e);
            return ErrorCode.CREDENTIAL_SIGNATURE_BROKEN;
        }
        if (!result) {
            return ErrorCode.CREDENTIAL_SIGNATURE_BROKEN;
        }
        return ErrorCode.SUCCESS;
    }

    private static boolean isSelectivelyDisclosed(Map<String, Object> saltMap) {
        if (saltMap == null) {
            return false;
        }
        for (Map.Entry<String, Object> entry : saltMap.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof Map ? CredentialPojoServiceImpl.isSelectivelyDisclosed((HashMap)v) : v instanceof List && CredentialPojoServiceImpl.isSelectivelyDisclosed((ArrayList)v)) {
                return true;
            }
            if (v == null) {
                throw new WeIdBaseException(ErrorCode.CREDENTIAL_SALT_ILLEGAL);
            }
            if (!"0".equals(v.toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSelectivelyDisclosed(List<Object> saltList) {
        if (saltList == null) {
            return false;
        }
        for (Object saltObj : saltList) {
            if (saltObj instanceof Map ? CredentialPojoServiceImpl.isSelectivelyDisclosed((HashMap)saltObj) : saltObj instanceof List && CredentialPojoServiceImpl.isSelectivelyDisclosed((ArrayList)saltObj)) {
                return true;
            }
            if (saltObj == null) {
                throw new WeIdBaseException(ErrorCode.CREDENTIAL_SALT_ILLEGAL);
            }
            if (!"0".equals(saltObj.toString())) continue;
            return true;
        }
        return false;
    }

    private static ErrorCode verifyCptFormat(Integer cptId, Map<String, Object> claim, boolean isSelectivelyDisclosed) {
        try {
            String claimStr = DataToolUtils.serialize(claim);
            Cpt cpt = cptService.queryCpt(cptId).getResult();
            if (cpt == null) {
                logger.error(ErrorCode.CREDENTIAL_CPT_NOT_EXISTS.getCodeDesc());
                return ErrorCode.CREDENTIAL_CPT_NOT_EXISTS;
            }
            String cptJsonSchema = DataToolUtils.serialize(cpt.getCptJsonSchema());
            if (!DataToolUtils.isCptJsonSchemaValid(cptJsonSchema)) {
                logger.error(ErrorCode.CPT_JSON_SCHEMA_INVALID.getCodeDesc());
                return ErrorCode.CPT_JSON_SCHEMA_INVALID;
            }
            if (!isSelectivelyDisclosed && !DataToolUtils.isValidateJsonVersusSchema(claimStr, cptJsonSchema)) {
                logger.error(ErrorCode.CREDENTIAL_CLAIM_DATA_ILLEGAL.getCodeDesc());
                return ErrorCode.CREDENTIAL_CLAIM_DATA_ILLEGAL;
            }
            return ErrorCode.SUCCESS;
        }
        catch (Exception e) {
            logger.error("Generic error occurred during verify cpt format when verifyCredential: " + e);
            return ErrorCode.CREDENTIAL_ERROR;
        }
    }

    @Override
    public ResponseData<CredentialPojo> createCredential(CreateCredentialPojoArgs args) {
        try {
            ErrorCode innerResponseData = CredentialPojoUtils.isCreateCredentialPojoArgsValid(args);
            if (ErrorCode.SUCCESS.getCode() != innerResponseData.getCode()) {
                logger.error("Create Credential Args illegal: {}", (Object)innerResponseData.getCodeDesc());
                return new ResponseData<Object>(null, innerResponseData);
            }
            CredentialPojo result = new CredentialPojo();
            String context = CredentialUtils.getDefaultCredentialContext();
            result.setContext(context);
            result.setId(UUID.randomUUID().toString());
            result.setCptId(args.getCptId());
            Long issuanceDate = args.getIssuanceDate();
            if (issuanceDate == null) {
                result.setIssuanceDate(DateUtils.getNoMillisecondTimeStamp());
            } else {
                Long newIssuanceDate = DateUtils.convertToNoMillisecondTimeStamp(args.getIssuanceDate());
                if (newIssuanceDate == null) {
                    logger.error("Create Credential Args illegal.");
                    return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL);
                }
                result.setIssuanceDate(newIssuanceDate);
            }
            if (!WeIdUtils.validatePrivateKeyWeIdMatches(args.getWeIdAuthentication().getWeIdPrivateKey(), args.getIssuer())) {
                logger.error("Create Credential, private key does not match the current weid.");
                return new ResponseData<Object>(null, ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH);
            }
            result.setIssuer(args.getIssuer());
            Long newExpirationDate = DateUtils.convertToNoMillisecondTimeStamp(args.getExpirationDate());
            if (newExpirationDate == null) {
                logger.error("Create Credential Args illegal.");
                return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_EXPIRE_DATE_ILLEGAL);
            }
            result.setExpirationDate(newExpirationDate);
            result.addType("VerifiableCredential");
            Object claimObject = args.getClaim();
            String claimStr = null;
            claimStr = !(claimObject instanceof String) ? DataToolUtils.serialize(claimObject) : (String)claimObject;
            HashMap claimMap = DataToolUtils.deserialize(claimStr, HashMap.class);
            result.setClaim(claimMap);
            Map saltMap = DataToolUtils.clone(claimMap);
            CredentialPojoServiceImpl.generateSalt(saltMap);
            String rawData = CredentialPojoUtils.getCredentialThumbprintWithoutSig(result, saltMap, null);
            String privateKey = args.getWeIdAuthentication().getWeIdPrivateKey().getPrivateKey();
            String signature = DataToolUtils.sign(rawData, privateKey);
            result.putProofValue("created", result.getIssuanceDate());
            String weIdPublicKeyId = args.getWeIdAuthentication().getWeIdPublicKeyId();
            result.putProofValue("creator", weIdPublicKeyId);
            String proofType = CredentialConstant.CredentialProofType.ECDSA.getTypeName();
            result.putProofValue("type", proofType);
            result.putProofValue("signatureValue", signature);
            result.setSalt(saltMap);
            ResponseData<CredentialPojo> responseData = new ResponseData<CredentialPojo>(result, ErrorCode.SUCCESS);
            return responseData;
        }
        catch (Exception e) {
            logger.error("Generate Credential failed due to system error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_ERROR);
        }
    }

    @Override
    public ResponseData<CredentialPojo> createSelectiveCredential(CredentialPojo credential, ClaimPolicy claimPolicy) {
        try {
            Map disclosureMap;
            CredentialPojo credentialClone = DataToolUtils.clone(credential);
            ErrorCode checkResp = CredentialPojoUtils.isCredentialPojoValid(credentialClone);
            if (ErrorCode.SUCCESS.getCode() != checkResp.getCode()) {
                return new ResponseData<Object>(null, checkResp);
            }
            if (claimPolicy == null) {
                logger.error("[createSelectiveCredential] claimPolicy is null.");
                return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_CLAIM_POLICY_NOT_EXIST);
            }
            String disclosure = claimPolicy.getFieldsToBeDisclosed();
            Map<String, Object> saltMap = credentialClone.getSalt();
            Map<String, Object> claim = credentialClone.getClaim();
            if (!CredentialPojoServiceImpl.validCredentialMapArgs(claim, saltMap, disclosureMap = (Map)DataToolUtils.deserialize(disclosure, HashMap.class))) {
                logger.error("[createSelectiveCredential] create failed. message is {}", (Object)ErrorCode.CREDENTIAL_POLICY_FORMAT_DOSE_NOT_MATCH_CLAIM.getCodeDesc());
                return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_POLICY_FORMAT_DOSE_NOT_MATCH_CLAIM);
            }
            CredentialPojoServiceImpl.addSelectSalt(disclosureMap, saltMap, claim);
            credentialClone.setSalt(saltMap);
            ResponseData<CredentialPojo> response = new ResponseData<CredentialPojo>();
            response.setResult(credentialClone);
            response.setErrorCode(ErrorCode.SUCCESS);
            return response;
        }
        catch (DataTypeCastException e) {
            logger.error("Generate SelectiveCredential failed, credential disclosure data type illegal. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_DISCLOSURE_DATA_TYPE_ILLEGAL);
        }
        catch (WeIdBaseException e) {
            logger.error("Generate SelectiveCredential failed, policy disclosurevalue illegal. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_POLICY_DISCLOSUREVALUE_ILLEGAL);
        }
        catch (Exception e) {
            logger.error("Generate SelectiveCredential failed due to system error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> verify(String issuerWeId, CredentialPojo credential) {
        String issuerId = credential.getIssuer();
        if (!StringUtils.equals((CharSequence)issuerWeId, (CharSequence)issuerId)) {
            logger.error("[verify] The input issuer weid is not match the credential's.");
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_ISSUER_MISMATCH);
        }
        ErrorCode errorCode = CredentialPojoServiceImpl.verifyContent(credential, null);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            logger.error("[verify] credential verify failed. error message :{}", (Object)errorCode);
            return new ResponseData<Boolean>(false, errorCode);
        }
        return new ResponseData<Boolean>(true, ErrorCode.SUCCESS);
    }

    @Override
    public ResponseData<Boolean> verify(String presenterWeId, PresentationPolicyE presentationPolicyE, Challenge challenge, PresentationE presentationE) {
        ErrorCode errorCode = this.checkInputArgs(presenterWeId, presentationPolicyE, challenge, presentationE);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            logger.error("[verify] checkInputArgs fail.");
            return new ResponseData<Boolean>(false, errorCode);
        }
        List<CredentialPojo> credentialList = presentationE.getVerifiableCredential();
        Map<Integer, ClaimPolicy> policyMap = presentationPolicyE.getPolicy();
        ErrorCode verifyCptIdresult = this.verifyCptId(policyMap, credentialList);
        if (verifyCptIdresult.getCode() != ErrorCode.SUCCESS.getCode()) {
            logger.error("[verify] verify cptId failed.");
            return new ResponseData<Boolean>(false, verifyCptIdresult);
        }
        try {
            for (CredentialPojo credential : credentialList) {
                ErrorCode verifypolicyResult;
                Integer cptId = credential.getCptId();
                ClaimPolicy claimPolicy = policyMap.get(cptId);
                if (claimPolicy != null && (verifypolicyResult = this.verifyPolicy(credential, claimPolicy, presenterWeId)).getCode() != ErrorCode.SUCCESS.getCode()) {
                    logger.error("[verify] verify policy {} failed.", policyMap);
                    return new ResponseData<Boolean>(false, verifypolicyResult);
                }
                ErrorCode verifyCredentialResult = CredentialPojoServiceImpl.verifyContent(credential, null);
                if (verifyCredentialResult.getCode() == ErrorCode.SUCCESS.getCode()) continue;
                logger.error("[verify] verify credential {} failed.", (Object)credential);
                return new ResponseData<Boolean>(false, verifyCredentialResult);
            }
            return new ResponseData<Boolean>(true, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("[verify] verify credential error.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> verify(WeIdPublicKey issuerPublicKey, CredentialPojo credential) {
        String publicKey = issuerPublicKey.getPublicKey();
        if (StringUtils.isEmpty((CharSequence)publicKey)) {
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_PUBLIC_KEY_NOT_EXISTS);
        }
        ErrorCode errorCode = CredentialPojoServiceImpl.verifyContent(credential, publicKey);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return new ResponseData<Boolean>(false, errorCode);
        }
        return new ResponseData<Boolean>(true, ErrorCode.SUCCESS);
    }

    private ErrorCode checkInputArgs(String presenterWeId, PresentationPolicyE presentationPolicyE, Challenge challenge, PresentationE presentationE) {
        if (StringUtils.isBlank((CharSequence)presenterWeId) || challenge == null || StringUtils.isBlank((CharSequence)challenge.getNonce()) || !CredentialPojoUtils.checkPresentationPolicyEValid(presentationPolicyE)) {
            logger.error("[verify] presentation verify failed, please check your input.");
            return ErrorCode.ILLEGAL_INPUT;
        }
        ErrorCode errorCode = CredentialPojoUtils.checkPresentationEValid(presentationE);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            logger.error("[verify] presentation verify failed, error message : {}", (Object)errorCode.getCodeDesc());
            return errorCode;
        }
        if (StringUtils.isNotBlank((CharSequence)challenge.getWeId()) && !presenterWeId.equals(challenge.getWeId())) {
            logger.error("[verify] The input issuer weid is not match the presentian's.");
            return ErrorCode.CREDENTIAL_PRESENTERWEID_NOTMATCH;
        }
        if (!challenge.getNonce().equals(presentationE.getNonce())) {
            logger.error("[verify] The nonce of challenge is not matched with the presentationE's.");
            return ErrorCode.PRESENTATION_CHALLENGE_NONCE_MISMATCH;
        }
        WeIdDocument weIdDocument = weIdService.getWeIdDocument(presenterWeId).getResult();
        if (weIdDocument == null) {
            logger.error("[verify]presentation verify failed, because the presenter weid :{} does not exist.", (Object)presenterWeId);
            return ErrorCode.WEID_DOES_NOT_EXIST;
        }
        String signature = presentationE.getSignature();
        errorCode = DataToolUtils.verifySignatureFromWeId(presentationE.toRawData(), signature, weIdDocument);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            logger.error("[verify] verify presentation signature failed, error message : {}.", (Object)errorCode.getCodeDesc());
            return ErrorCode.PRESENTATION_SIGNATURE_MISMATCH;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode verifyCptId(Map<Integer, ClaimPolicy> policyMap, List<CredentialPojo> credentialList) {
        if (policyMap.size() > credentialList.size()) {
            return ErrorCode.CREDENTIAL_CPTID_NOTMATCH;
        }
        List cptIdList = credentialList.stream().map(cpwl -> cpwl.getCptId()).collect(Collectors.toList());
        if (cptIdList == null || cptIdList.isEmpty()) {
            return ErrorCode.CREDENTIAL_CPTID_NOTMATCH;
        }
        if (!cptIdList.containsAll(policyMap.keySet())) {
            return ErrorCode.CREDENTIAL_CPTID_NOTMATCH;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode verifyDisclosureAndSalt(Map<String, Object> disclosureMap, Map<String, Object> saltMap) {
        for (String disclosureK : disclosureMap.keySet()) {
            Object disclosureV = disclosureMap.get(disclosureK);
            Object saltV = saltMap.get(disclosureK);
            if (disclosureV instanceof Map) {
                ErrorCode code = this.verifyDisclosureAndSalt((HashMap)disclosureV, (HashMap)saltV);
                if (code.getCode() == ErrorCode.SUCCESS.getCode()) continue;
                return code;
            }
            if (disclosureV instanceof List) {
                ArrayList disclosurs = (ArrayList)disclosureV;
                ErrorCode code = this.verifyDisclosureAndSaltList(disclosurs, (List<Object>)((ArrayList)saltV));
                if (code.getCode() == ErrorCode.SUCCESS.getCode()) continue;
                return code;
            }
            String disclosure = String.valueOf(disclosureV);
            String salt = String.valueOf(saltV);
            if (!(disclosure.equals(NOT_DISCLOSED) || disclosure.equals(DISCLOSED) || disclosure.equals(EXISTED))) {
                logger.error("[verifyDisclosureAndSalt] policy disclosureValue {} illegal.", disclosureMap);
                return ErrorCode.CREDENTIAL_POLICY_DISCLOSUREVALUE_ILLEGAL;
            }
            if (StringUtils.isEmpty((CharSequence)salt)) {
                return ErrorCode.CREDENTIAL_POLICY_DISCLOSUREVALUE_ILLEGAL;
            }
            if (disclosure.equals(NOT_DISCLOSED) && salt.length() > 1 || disclosure.equals(NOT_DISCLOSED) && !salt.equals(NOT_DISCLOSED)) {
                return ErrorCode.CREDENTIAL_DISCLOSUREVALUE_NOTMATCH_SALTVALUE;
            }
            if (!disclosure.equals(DISCLOSED) || salt.length() > 1) continue;
            return ErrorCode.CREDENTIAL_DISCLOSUREVALUE_NOTMATCH_SALTVALUE;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode verifyDisclosureAndSaltList(List<Object> disclosureList, List<Object> saltList) {
        for (int i = 0; i < disclosureList.size(); ++i) {
            ErrorCode code;
            Object disclosure = disclosureList.get(i);
            Object saltV = saltList.get(i);
            if (!(disclosure instanceof Map ? (code = this.verifyDisclosureAndSaltList((HashMap)disclosure, (List<Object>)((ArrayList)saltList))).getCode() != ErrorCode.SUCCESS.getCode() : disclosure instanceof List && (code = this.verifyDisclosureAndSaltList((ArrayList)disclosure, (List<Object>)((ArrayList)saltV))).getCode() != ErrorCode.SUCCESS.getCode())) continue;
            return code;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode verifyDisclosureAndSaltList(Map<String, Object> disclosure, List<Object> saltList) {
        for (int i = 0; i < saltList.size(); ++i) {
            Object saltV = saltList.get(i);
            ErrorCode code = this.verifyDisclosureAndSalt((HashMap)disclosure, (HashMap)saltV);
            if (code.getCode() == ErrorCode.SUCCESS.getCode()) continue;
            return code;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode verifyPolicy(CredentialPojo credentialPojo, ClaimPolicy claimPolicy, String presenterWeId) {
        Map<String, Object> saltMap = credentialPojo.getSalt();
        String disclosure = claimPolicy.getFieldsToBeDisclosed();
        Map disclosureMap = DataToolUtils.deserialize(disclosure, HashMap.class);
        Object idValue = disclosureMap.get("id");
        if (idValue != null) {
            Object weid = credentialPojo.getClaim().get("id");
            if (StringUtils.equals((CharSequence)String.valueOf(idValue), (CharSequence)DISCLOSED)) {
                if (!StringUtils.equals((CharSequence)String.valueOf(weid), (CharSequence)presenterWeId)) {
                    logger.error("[verifyPolicy] the presenter weid->{} of presentation does not match the credential's ->{}. ", (Object)presenterWeId, weid);
                    return ErrorCode.PRESENTATION_WEID_CREDENTIAL_WEID_MISMATCH;
                }
            } else if (StringUtils.equals((CharSequence)String.valueOf(idValue), (CharSequence)EXISTED) && !credentialPojo.getClaim().containsKey("id")) {
                logger.error("[verifyPolicy] the presenter weid->{} of presentation does not match the credential's ->{}. ", (Object)presenterWeId, weid);
                return ErrorCode.PRESENTATION_CREDENTIAL_CLAIM_WEID_NOT_EXIST;
            }
        }
        return this.verifyDisclosureAndSalt(disclosureMap, saltMap);
    }

    @Override
    public ResponseData<PresentationE> createPresentation(List<CredentialPojo> credentialList, PresentationPolicyE presentationPolicyE, Challenge challenge, WeIdAuthentication weIdAuthentication) {
        PresentationE presentation = new PresentationE();
        try {
            ErrorCode errorCode = this.validateCreateArgs(credentialList, presentationPolicyE, challenge, weIdAuthentication);
            if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
                logger.error("check input error:{}-{}", (Object)errorCode.getCode(), (Object)errorCode.getCodeDesc());
                return new ResponseData<Object>(null, errorCode);
            }
            errorCode = this.processCredentialList(credentialList, presentationPolicyE, presentation);
            if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
                logger.error("process credentialList error:{}-{}", (Object)errorCode.getCode(), (Object)errorCode.getCodeDesc());
                return new ResponseData<Object>(null, errorCode);
            }
            presentation.getContext().add("https://github.com/WeBankFinTech/WeIdentity/blob/master/context/v1");
            presentation.getType().add("VerifiablePresentation");
            this.generatePresentationProof(challenge, weIdAuthentication, presentation);
            return new ResponseData<PresentationE>(presentation, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("create PresentationE error", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    private ErrorCode validateCreateArgs(List<CredentialPojo> credentialList, PresentationPolicyE presentationPolicyE, Challenge challenge, WeIdAuthentication weIdAuthentication) {
        if (challenge == null || weIdAuthentication == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (StringUtils.isBlank((CharSequence)challenge.getNonce()) || challenge.getVersion() == null) {
            return ErrorCode.PRESENTATION_CHALLENGE_INVALID;
        }
        if (weIdAuthentication.getWeIdPrivateKey() == null || !WeIdUtils.validatePrivateKeyWeIdMatches(weIdAuthentication.getWeIdPrivateKey(), weIdAuthentication.getWeId())) {
            return ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH;
        }
        if (!StringUtils.isBlank((CharSequence)challenge.getWeId()) && !challenge.getWeId().equals(weIdAuthentication.getWeId())) {
            return ErrorCode.PRESENTATION_CHALLENGE_WEID_MISMATCH;
        }
        if (StringUtils.isBlank((CharSequence)weIdAuthentication.getWeIdPublicKeyId())) {
            return ErrorCode.PRESENTATION_WEID_PUBLICKEY_ID_INVALID;
        }
        return this.validateClaimPolicy(credentialList, presentationPolicyE);
    }

    private ErrorCode validateClaimPolicy(List<CredentialPojo> credentialList, PresentationPolicyE presentationPolicyE) {
        Set<Integer> claimPolicyCptSet;
        if (CollectionUtils.isEmpty(credentialList)) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (presentationPolicyE == null || presentationPolicyE.getPolicy() == null) {
            return ErrorCode.PRESENTATION_POLICY_INVALID;
        }
        if (!WeIdUtils.isWeIdValid(presentationPolicyE.getPolicyPublisherWeId())) {
            return ErrorCode.PRESENTATION_POLICY_PUBLISHER_WEID_INVALID;
        }
        ResponseData<Boolean> weIdRes = weIdService.isWeIdExist(presentationPolicyE.getPolicyPublisherWeId());
        if (ErrorCode.SUCCESS.getCode() != weIdRes.getErrorCode().intValue() || !weIdRes.getResult().booleanValue()) {
            return ErrorCode.PRESENTATION_POLICY_PUBLISHER_WEID_NOT_EXIST;
        }
        for (CredentialPojo credentialPojo : credentialList) {
            ErrorCode checkResp = CredentialPojoUtils.isCredentialPojoValid(credentialPojo);
            if (ErrorCode.SUCCESS.getCode() == checkResp.getCode()) continue;
            return checkResp;
        }
        List cptIdList = credentialList.stream().map(cpwl -> cpwl.getCptId()).collect(Collectors.toList());
        if (!cptIdList.containsAll(claimPolicyCptSet = presentationPolicyE.getPolicy().keySet())) {
            return ErrorCode.PRESENTATION_CREDENTIALLIST_MISMATCH_CLAIM_POLICY;
        }
        return ErrorCode.SUCCESS;
    }

    private ErrorCode processCredentialList(List<CredentialPojo> credentialList, PresentationPolicyE presentationPolicy, PresentationE presentation) {
        ArrayList<CredentialPojo> newCredentialList = new ArrayList<CredentialPojo>();
        Map<Integer, ClaimPolicy> claimPolicyMap = presentationPolicy.getPolicy();
        for (CredentialPojo credential : credentialList) {
            ClaimPolicy claimPolicy = claimPolicyMap.get(credential.getCptId());
            if (claimPolicy == null) continue;
            ResponseData<CredentialPojo> res = this.createSelectiveCredential(credential, claimPolicy);
            if (res.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                return ErrorCode.getTypeByErrorCode(res.getErrorCode());
            }
            newCredentialList.add(res.getResult());
        }
        presentation.setVerifiableCredential(newCredentialList);
        return ErrorCode.SUCCESS;
    }

    private void generatePresentationProof(Challenge challenge, WeIdAuthentication weIdAuthentication, PresentationE presentation) {
        String proofType = CredentialConstant.CredentialProofType.ECDSA.getTypeName();
        presentation.putProofValue("type", proofType);
        Long proofCreated = DateUtils.getNoMillisecondTimeStamp();
        presentation.putProofValue("created", proofCreated);
        String weIdPublicKeyId = weIdAuthentication.getWeIdPublicKeyId();
        presentation.putProofValue("verificationMethod", weIdPublicKeyId);
        presentation.putProofValue("nonce", challenge.getNonce());
        String signature = DataToolUtils.sign(presentation.toRawData(), weIdAuthentication.getWeIdPrivateKey().getPrivateKey());
        presentation.putProofValue("signatureValue", signature);
    }
}

